
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.state_engine.StateObject;

public class PlayerBulletObject extends StateObject {

    private double x;

    private double y;

    private double xSpeed;

    private double ySpeed;

    public PlayerBulletObject(double x, double y, double xSpeed, double ySpeed) {
        this.x = x;
        this.y = y;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;

        PlayerBulletDrawState drawState = new PlayerBulletDrawState();
        drawState.getDestinationTransitionList().add(new PlayerBulletDisposeTransition());
        this.getStateList().add(drawState);

        PlayerBulletMoveState moveState = new PlayerBulletMoveState();
        moveState.getDestinationTransitionList().add(new PlayerBulletDisposeTransition());
        this.getStateList().add(moveState);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getXSpeed() {
        return this.xSpeed;
    }

    public void setXSpeed(double speed) {
        xSpeed = speed;
    }

    public double getYSpeed() {
        return this.ySpeed;
    }

    public void setYSpeed(double speed) {
        ySpeed = speed;
    }

}
