
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.state_engine.StateObject;

public class EnemyBulletObject extends StateObject {

    private double x;

    private double y;

    private double xSpeed;

    private double ySpeed;

    public EnemyBulletObject(double x, double y, double xSpeed, double ySpeed) {
        this.x = x;
        this.y = y;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;

        EnemyBulletDrawState drawState = new EnemyBulletDrawState();
        drawState.getDestinationTransitionList().add(new EnemyBulletDisposeTransition());
        this.getStateList().add(drawState);

        EnemyBulletMoveState moveState = new EnemyBulletMoveState();
        moveState.getDestinationTransitionList().add(new EnemyBulletDisposeTransition());
        this.getStateList().add(moveState);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getXSpeed() {
        return this.xSpeed;
    }

    public void setXSpeed(double speed) {
        xSpeed = speed;
    }

    public double getYSpeed() {
        return this.ySpeed;
    }

    public void setYSpeed(double speed) {
        ySpeed = speed;
    }

}
