
package jp.gr.java_conf.u6k.sample.danmaku2;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyBulletMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyBulletObject obj = (EnemyBulletObject) ctx.getTarget();

        double x = obj.getX();
        double y = obj.getY();
        double angle = obj.getAngle();
        double speed = obj.getSpeed();

        // 計算
        x += speed * Math.cos(angle);
        y += speed * Math.sin(angle);

        // 設定
        obj.setX(x);
        obj.setY(y);
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
