
package jp.gr.java_conf.u6k.sample.danmaku1;

import jp.gr.java_conf.u6k.state_engine.StateObject;

@SuppressWarnings("serial")
public class EnemyBulletObject extends StateObject {

    private double x;

    private double y;

    private double angle;

    private double speed;

    public EnemyBulletObject(double x, double y, double angle, double speed) {
        EnemyBulletMoveState moveState = new EnemyBulletMoveState();
        moveState.getDestinationTransitionList().add(new EnemyBulletDisposedTransition());
        this.getStateList().add(moveState);

        EnemyBulletDrawState drawState = new EnemyBulletDrawState();
        drawState.getDestinationTransitionList().add(new EnemyBulletDisposedTransition());
        this.getStateList().add(drawState);

        this.x = x;
        this.y = y;
        this.angle = angle;
        this.speed = speed;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

}
