import jp.gr.java_conf.u6k.animation.AbstractFpsListener;
import jp.gr.java_conf.u6k.animation.AnimationListener;
import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.WaitListener;
import jp.gr.java_conf.u6k.sample.stg1.SceneObject;
import jp.gr.java_conf.u6k.state_engine.StateEngine;

// TODO オブジェクト間のメッセージ伝播。
// TODO オブジェクト、状態、システム全体それぞれに値を持たせられるようにする。
// TODO 状態コンテキストも継承実装にする。使用する型情報はどこで設定する?
// TODO 状態遷移の外部情報化。
// TODO 階層状態。
// TODO 開始状態、終了状態、初期値の初期化方法、などなど、状態遷移マシンとしての設計をちゃんと考え直す必要がある。ALBPMはその辺、割と参考になる。
// TODO State、StateObject、Transitionに遷移情報などを持たせてはならない。外部操作される可能性がある。
// TODO オブジェクトのグループ化。
// TODO もうちょっとスマートなオブジェクト管理。
// TODO メモリの効率的な管理。
// TODO エディタ。
// TODO 全画面モード。
// TODO 処理、描画の優先順位。
// TODO リプレイ機能。ぶっちゃけ、入力のシミュレーション。
// TODO 正確なシミュレーション。doubleは正確に再現できないんじゃ?　数値型を考える。
// TODO フレームワーク・クラスのアクセス制御。

public class Main {

    public static void main(String[] args) throws Exception {
        AnimationWindow w = new AnimationWindow(640, 480, "state-engine");
        w.addAnimationListener(new AnimationListener() {

            private StateEngine stateEngine;
            {
                this.stateEngine = new StateEngine(new SceneObject());
            }

            public void draw(AnimationWindow window) {
                window.getCanvas().clearRect(0, 0, window.getWidth(), window.getHeight());

                this.stateEngine.execute(window);
            }

        });
        w.addAnimationListener(new WaitListener(60));
        w.addAnimationListener(new AbstractFpsListener() {

            @Override
            public void elapsed(double fps) {
                // System.out.println("fps: " + fps);
            }

        });
        w.show();
    }

}
