﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Collections.Specialized;
using System.Security.Cryptography.X509Certificates;
using System.Net.Security;
using System.Text.RegularExpressions;
using System.IO;
using System.Reflection;
using System.Globalization;
using System.Web;
using System.Configuration;

namespace HgCo.WindowsLive.SkyDrive.Sample.ConsoleApplication
{
    /// <summary>
    /// 
    /// </summary>
    public class Program
    {
        private const string TestWebFolderName = "Testing SkyDrive API";
        private const string TestWebFileName1 = "sample.txt";
        private const string TestWebFileName2 = "sample.png";
        private const string TestWebFileName3 = "sample.url";

        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            // Instantiate SkyDrive API client
            SkyDriveWebClient wcSkyDrive = new SkyDriveWebClient();
            WebFolderInfo testWebFolder = null;

            try
            {
                // Log on to a user account
                wcSkyDrive.LogOn(
                    ConfigurationSettings.AppSettings["UserName"],
                    ConfigurationSettings.AppSettings["Password"]);

                // Create a folder in SkyDrive's root
                wcSkyDrive.CreateRootWebFolder(TestWebFolderName, WebFolderItemShareType.Private);

                // List folders in SkyDrive's root and find the test folder
                WebFolderInfo[] rootWebFolders = wcSkyDrive.ListRootWebFolders();
                foreach (WebFolderInfo rootWebFolder in rootWebFolders)
                    if (rootWebFolder.Name == TestWebFolderName)
                    {
                        testWebFolder = rootWebFolder;
                        break;
                    }

                // Change folder ContentType to Documents
                wcSkyDrive.ChangeRootWebFolderContentType(testWebFolder, WebFolderContentType.Favorites);
                wcSkyDrive.ChangeRootWebFolderContentType(testWebFolder, WebFolderContentType.Documents);

                // Refresh test webfolder entity
                testWebFolder = wcSkyDrive.GetWebFolder(testWebFolder);

                WebFolderItemInfo[] items = wcSkyDrive.ListSubWebFolderItems(rootWebFolders[6]);

                // Download test webfolder icon
                System.Drawing.Image imgTestContentType = wcSkyDrive.DownloadWebFolderItemImage(testWebFolder.WebIcon.ContentTypeWebImage);
                if (imgTestContentType != null)
                    imgTestContentType.Save("TestWebFolder.ContentType.png", System.Drawing.Imaging.ImageFormat.Png);
                System.Drawing.Image imgTestContent = wcSkyDrive.DownloadWebFolderItemImage(testWebFolder.WebIcon.ContentWebImage);
                if (imgTestContent != null)
                    imgTestContent.Save("TestWebFolder.Content.png", System.Drawing.Imaging.ImageFormat.Png);
                System.Drawing.Image imgTestShareType = wcSkyDrive.DownloadWebFolderItemImage(testWebFolder.WebIcon.ShareTypeWebImage);
                if (imgTestShareType != null)
                    imgTestShareType.Save("TestWebFolder.ShareType.png", System.Drawing.Imaging.ImageFormat.Png);
                System.Drawing.Image imgTestIcon = wcSkyDrive.DownloadWebFolderItemIcon(testWebFolder.WebIcon);
                imgTestIcon.Save("TestWebFolder.Icon.png", System.Drawing.Imaging.ImageFormat.Png);

                // Create a sub folder
                wcSkyDrive.CreateSubWebFolder(TestWebFolderName, testWebFolder);

                // List test folder's sub folders
                WebFolderInfo[] testWebFolders = wcSkyDrive.ListSubWebFolders(testWebFolder);
                foreach (WebFolderInfo webFolder in testWebFolders)
                {
                    wcSkyDrive.ChangeWebFolderDescription(
                        webFolder,
                        String.Format("Description for {0}.", webFolder.Name));
                    wcSkyDrive.GetWebFolder(webFolder);
                }

                // Upload sample files
                wcSkyDrive.UploadWebFile(TestWebFileName1, testWebFolder);
                wcSkyDrive.UploadWebFile(TestWebFileName2, testWebFolder);
                wcSkyDrive.UploadWebFile(TestWebFileName3, testWebFolder);

                // List test folder's files
                WebFileInfo[] testWebFiles = wcSkyDrive.ListSubWebFolderFiles(testWebFolder);
                foreach (WebFileInfo webFile in testWebFiles)
                {
                    wcSkyDrive.ChangeWebFileDescription(
                        webFile,
                        String.Format("Description for {0}.", webFile.Name));
                    wcSkyDrive.GetWebFile(webFile);
                }

                // List test folder's items
                WebFolderItemInfo[] testWebFolderItems = wcSkyDrive.ListSubWebFolderItems(testWebFolder, WebFolderViewType.Thumbnails);

                // Download test folder as a .zip file
                using (Stream sr = wcSkyDrive.DownloadWebFolder(testWebFolder))
                using (FileStream fs = new FileStream(String.Format("{0}.zip", testWebFolder.Name), FileMode.OpenOrCreate))
                {
                    byte[] buffer = new byte[64 * 1024];
                    int count = 0;
                    while ((count = sr.Read(buffer, 0, buffer.Length)) > 0)
                        fs.Write(buffer, 0, count);
                }

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
            finally
            {
                if (testWebFolder != null)
                {
                    // Delete test folder recursively
                    wcSkyDrive.DeleteWebFolder(testWebFolder);
                }
            }
        }

    }
}