﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace HgCo.WindowsLive.SkyDrive
{
    /// <summary>
    /// Provides webfolder content specific data.
    /// </summary>
    public class WebFolderInfo : WebFolderItemInfo
    {
        #region Properties
        
        /// <summary>
        /// Gets or sets ContentType.
        /// </summary>
        /// <value>The ContentType.</value>
        public WebFolderContentType ContentType { get; set; }

        /// <summary>
        /// Gets a value indicating whether this webfolder is a root webfolder.
        /// </summary>
        /// <value><c>true</c> if this webfolder is root; otherwise, <c>false</c>.</value>
        public bool IsRoot 
        { 
            get 
            {
                bool isRoot = false;
                if (!String.IsNullOrEmpty(PathUrl))
                    isRoot = PathUrl.LastIndexOf(PathUrlSegmentDelimiter) == 0;
                return isRoot;
            } 
        }

        /// <summary>
        /// Gets or sets the sub webfolderitems.
        /// </summary>
        /// <value>The sub webfolderitems.</value>
        public Collection<WebFolderItemInfo> SubItems { get; private set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="WebFolderInfo"/> class.
        /// </summary>
        public WebFolderInfo()
        {
            ItemType = WebFolderItemType.Folder;
            SubItems = new Collection<WebFolderItemInfo>();
        }

        #endregion

        #region Methods

        /// <summary>
        /// Gets the webfolders from the list of SubItems.
        /// </summary>
        /// <returns>The list of webfolders.</returns>
        public WebFolderInfo[] GetSubFolders()
        {
            List<WebFolderInfo> lSubFolder = new List<WebFolderInfo>(SubItems.Count);
            foreach (WebFolderItemInfo webFolderItem in SubItems)
                if (webFolderItem != null && webFolderItem.ItemType == WebFolderItemType.Folder)
                    lSubFolder.Add(webFolderItem as WebFolderInfo);
            return lSubFolder.ToArray();
        }

        /// <summary>
        /// Gets the webfiles from the list of SubItems.
        /// </summary>
        /// <returns>The list of webfiles.</returns>
        public WebFileInfo[] GetFiles()
        {
            List<WebFileInfo> lFile = new List<WebFileInfo>(SubItems.Count);
            foreach (WebFolderItemInfo webFolderItem in SubItems)
                if (webFolderItem != null && webFolderItem.ItemType == WebFolderItemType.File)
                    lFile.Add(webFolderItem as WebFileInfo);
            return lFile.ToArray();
        }

        #endregion
    }
}
