﻿using System;
using System.Globalization;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling enum <see cref="E:WebFolderViewType"/>.
    /// </summary>
    internal static class WebFolderViewTypeHelper
    {
        /// <summary>
        /// Parses the ViewType from a string.
        /// </summary>
        /// <param name="viewTypeText">The ViewType text.</param>
        /// <returns>The parsed ViewType.</returns>
        public static WebFolderViewType ParseViewType(string viewTypeText)
        {
            WebFolderViewType viewType = WebFolderViewType.None;
            if (!String.IsNullOrEmpty(viewTypeText))
            {
                viewTypeText = viewTypeText.ToLower(CultureInfo.InvariantCulture);
                if (viewTypeText.Contains("details"))
                    viewType = WebFolderViewType.Details;
                else if (viewTypeText.Contains("icons"))
                    viewType = WebFolderViewType.Icons;
                else if (viewTypeText.Contains("thumbnails"))
                    viewType = WebFolderViewType.Thumbnails;
            }
            return viewType;
        }

        /// <summary>
        /// Gets a string representing the specified ViewType for operation postback.
        /// </summary>
        /// <param name="viewType">The ViewType.</param>
        /// <returns>The ViewType string.</returns>
        public static string GetViewTypeForPostback(WebFolderViewType viewType)
        {
            string viewTypeText = String.Empty;
            switch(viewType)
            {
                case WebFolderViewType.Thumbnails:
                    viewTypeText = "Thumbs";
                    break;
                default:
                    viewTypeText = viewType.ToString();
                    break;
            }
            return viewTypeText;
        }
    }
}
