﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Collections.Specialized;
using System.Security.Cryptography.X509Certificates;
using System.Net.Security;
using System.Text.RegularExpressions;
using System.IO;
using System.Reflection;
using System.Globalization;
using System.Web;
using System.Configuration;

namespace HgCo.WindowsLive.SkyDrive.Sample.ConsoleApplication
{
    /// <summary>
    /// 
    /// </summary>
    public class Program
    {
        private const string TestWebFolderName = "Testing SkyDrive API";
        private const string TestWebFileName1 = "sample.txt";
        private const string TestWebFileName2 = "sample.png";

        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            // Instantiate SkyDrive API client
            SkyDriveWebClient wcSkyDrive = new SkyDriveWebClient();
            
            // Log on to a user account
            wcSkyDrive.LogOn(
                ConfigurationSettings.AppSettings["UserName"],
                ConfigurationSettings.AppSettings["Password"]);

            // Create a folder in SkyDrive's root
            wcSkyDrive.CreateRootWebFolder(TestWebFolderName, WebFolderItemShareType.Private);

            // List folders in SkyDrive's root and find the test folder
            WebFolderInfo[] rootWebFolders = wcSkyDrive.ListRootWebFolders();
            WebFolderInfo testWebFolder = null;
            foreach (WebFolderInfo rootWebFolder in rootWebFolders)
                if (rootWebFolder.Name == TestWebFolderName)
                {
                    testWebFolder = rootWebFolder;
                    break;
                }

            // Changes folder ContentType to Documents
            wcSkyDrive.ChangeRootWebFolderContentType(testWebFolder, WebFolderContentType.Photos);
            wcSkyDrive.ChangeRootWebFolderContentType(testWebFolder, WebFolderContentType.Documents);

            // Upload 2 sample files
            wcSkyDrive.UploadWebFile(TestWebFileName1, testWebFolder);
            wcSkyDrive.UploadWebFile(TestWebFileName2, testWebFolder);

            // List test folder's files
            WebFileInfo[] testWebFiles = wcSkyDrive.ListSubWebFolderFiles(testWebFolder);
            foreach (WebFileInfo testWebFile in testWebFiles)
                wcSkyDrive.ChangeWebFileDescription(
                    testWebFile, 
                    String.Format("Description for {0}.", testWebFile.Name));

            // Download test folder as a .zip file
            using (Stream sr = wcSkyDrive.DownloadWebFolder(testWebFolder))
                using (FileStream fs = new FileStream(String.Format("{0}.zip", testWebFolder.Name), FileMode.OpenOrCreate))
                {
                    byte[] buffer = new byte[64 * 1024];
                    int count = 0;
                    while ((count = sr.Read(buffer, 0, buffer.Length)) > 0)
                        fs.Write(buffer, 0, count);
                }

            // Delete test folder recursively
            wcSkyDrive.DeleteWebFolder(testWebFolder);
        }

        private static bool customXertificateValidation(object sender, X509Certificate cert, X509Chain chain, SslPolicyErrors error)
        {
            return true;
        }

        private static string[] ParseCookieContent(WebHeaderCollection responseHeaders)
        {
            List<string> cookies = new List<string>();
            string respHeaderSetCookies = responseHeaders["Set-Cookie"];

            if (!String.IsNullOrEmpty(respHeaderSetCookies))
            {
                string[] setCookies = respHeaderSetCookies.Split(',');
                foreach (string setCookie in setCookies)
                {
                    string[] cookieSections = setCookie.Split(';');
                    cookies.Add(cookieSections[0]);
                }
            }
            return cookies.ToArray();
        }
    }
}