﻿using System;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling enum <see cref="E:WebFolderItemShareType"/>.
    /// </summary>
    internal static class WebFolderItemShareTypeHelper
    {
        /// <summary>
        /// Parses the ShareType from a string.
        /// </summary>
        /// <param name="sharedWith">The ShareType text.</param>
        /// <returns>The parsed ShareType.</returns>
        public static WebFolderItemShareType ParseShareType(string sharedWith)
        {
            WebFolderItemShareType shareType = WebFolderItemShareType.None;
            if (!String.IsNullOrEmpty(sharedWith))
            {
                if (sharedWith.Equals("everyone (public)", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.Public;
                else if (sharedWith.Equals("my network", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.MyNetwork;
                else if (sharedWith.Equals("people i selected", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.PeopleSelected;
                else if (sharedWith.Equals("just me", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.Private;
            }
            return shareType;
        }
    }
}
