﻿using System;

namespace HgCo.WindowsLive.SkyDrive
{
    /// <summary>
    /// Provides webfolderitem content specific data. This is an <c>abstract</c> class.
    /// </summary>
    public abstract class WebFolderItemInfo
    {
        #region Properties

        /// <summary>
        /// Gets or sets the ItemType.
        /// </summary>
        /// <value>The ItemType.</value>
        public WebFolderItemType ItemType { get; protected set; }

        /// <summary>
        /// Gets or sets the name of the item's creator.
        /// </summary>
        /// <value>The name of the item's creator.</value>
        public string CreatorName { get; set; }

        /// <summary>
        /// Gets or sets the URI to the creator's profile.
        /// </summary>
        /// <value>The URI to the creator's profile.</value>
        public Uri CreatorUri { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>The name.</value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>The description.</value>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the ShareType.
        /// </summary>
        /// <value>The ShareType.</value>
        public WebFolderItemShareType ShareType { get; set; }

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        /// <value>The size.</value>
        public string Size { get; set; }

        /// <summary>
        /// Gets or sets the date when item was added.
        /// </summary>
        /// <value>The date when item was added.</value>
        public DateTime DateAdded { get; set; }

        /// <summary>
        /// Gets or sets the date when item was modified.
        /// </summary>
        /// <value>The date when item was modified.</value>
        public DateTime DateModified { get; set; }

        /// <summary>
        /// Gets or sets the path URL.
        /// </summary>
        /// <value>The path URL.</value>
        public string PathUrl { get; set; }

        #endregion

        #region Methods

        /// <summary>
        /// Returns a <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
        /// </summary>
        /// <returns>
        /// A <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
        /// </returns>
        public override string ToString()
        {
            return ShareType != WebFolderItemShareType.None ?
                String.Format("{0} ({1})", Name, ShareType) : Name;
        }

        #endregion
    }
}
