﻿using System;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling enum <see cref="E:WebFolderContentType"/>.
    /// </summary>
    internal static class WebFolderContentTypeHelper
    {
        /// <summary>
        /// Parses the ContentType from a string.
        /// </summary>
        /// <param name="contentTypeText">The ContentType text.</param>
        /// <returns>The parsed ContentType.</returns>
        public static WebFolderContentType ParseContentType(string contentTypeText)
        {
            WebFolderContentType contentType = WebFolderContentType.None;
            if (!String.IsNullOrEmpty(contentTypeText))
            {
                contentTypeText = contentTypeText.ToLower();
                if (contentTypeText.Contains("documents"))
                    contentType = WebFolderContentType.Documents;
                else if (contentTypeText.Contains("favorites"))
                    contentType = WebFolderContentType.Favorites;
                else if (contentTypeText.Contains("photos"))
                    contentType = WebFolderContentType.Photos;
            }
            return contentType;
        }
    }
}