﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

using NUnit.Framework;

using SkyDriveFolder;

namespace SkyDriveFolderTest
{
    [TestFixture]
    class SkyDriveModelTest
    {
        #region 定数、インスタンス変数

        private const string TEST_ID = "skydrivetest001@gmail.com";

        private const string TEST_PASS = "";

        private SkyDriveModel _model;

        private SkyDriveFolder.SkyDriveFolder _testFolder;

        private DirectoryInfo _testDataFolder;

        #endregion

        #region テスト準備、後始末

        [TestFixtureSetUp]
        public void SetUp()
        {
            this._model = new SkyDriveModel();
            this._model.Signin(TEST_ID, TEST_PASS);
            this._model.CreateRootFolder("てすと");

            SkyDriveFolder.SkyDriveFolder rootFolder = this._model.RootFolder;
            this._model.RequestFolder(rootFolder);
            foreach (SkyDriveFolder.SkyDriveFolder folder in rootFolder.FolderList)
            {
                if (folder.Info.Name == "てすと")
                {
                    this._testFolder = folder;
                }
            }

            this._testDataFolder = new DirectoryInfo("../../TestData/");
        }

        [TestFixtureTearDown]
        public void TearDown()
        {
            this._model.DeleteFolder(this._testFolder);
            this._model = null;
        }

        #endregion

        #region テスト

        [Test]
        public void ListRootFolder()
        {
            SkyDriveFolder.SkyDriveFolder rootFolder = this._model.RootFolder;
            this._model.RequestFolder(rootFolder);

            List<SkyDriveFolder.SkyDriveFolder> folderList = rootFolder.FolderList;

            Assert.AreEqual(4, folderList.Count);
            Assert.AreEqual("Public", folderList[0].Info.Name);
            Assert.AreEqual("てすと", folderList[1].Info.Name);
            Assert.AreEqual("Favorites", folderList[2].Info.Name);
            Assert.AreEqual("Shared favorites", folderList[3].Info.Name);
        }

        [Test]
        public void Foo()
        {
            FileInfo uploadFile = new FileInfo(this._testDataFolder.FullName + Path.DirectorySeparatorChar + "test.txt");

            List<FileSystemInfo> uploadFileList = new List<FileSystemInfo>();
            uploadFileList.Add(uploadFile);

            this._model.UploadFile(this._testFolder, uploadFileList);

            this._model.RequestFolder(this._testFolder);

            Assert.AreEqual(0, this._testFolder.FolderList.Count);
            Assert.AreEqual(1, this._testFolder.FileList.Count);
            Assert.AreEqual("test.txt", this._testFolder.FileList[0].Info.Name);
        }

        #endregion

        #region テスト補助メソッド
        #endregion
    }
}
