﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using HgCo.WindowsLive.SkyDrive;

namespace SkyDriveFolder
{
    public partial class SigninControl : UserControl
    {
        private SkyDriveModel _model;

        private Exception _ex;

        public SigninControl()
        {
            InitializeComponent();
        }

        public SigninControl(SkyDriveModel model)
            : this()
        {
            try
            {
                _model = model;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void signinButton_Click(object sender, EventArgs e)
        {
            try
            {
                idField.Enabled = false;
                passwordField.Enabled = false;
                signinButton.Enabled = false;

                Thread t = new Thread(new ThreadStart(DoSignin));
                t.Start();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void DoSignin()
        {
            try
            {
                _model.Signin(idField.Text, passwordField.Text);
            }
            catch (LogOnFailedException)
            {
                this.Invoke(new MethodInvoker(delegate()
                {
                    try
                    {
                        idField.Enabled = true;
                        passwordField.Enabled = true;
                        signinButton.Enabled = true;

                        MessageBox.Show(this,
                            "サインインできませんでした。" + Environment.NewLine + "Windows Live ID、パスワードを確認してください。",
                            "SkyDriveFolder - サインイン・エラー",
                            MessageBoxButtons.OK,
                            MessageBoxIcon.Warning);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.ToString());
                        throw ex;
                    }
                }));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }
    }
}
