using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;

namespace TypingManager
{
    public class MultipleBootCheck
    {
        // OvZX̃CEEBhEN邽߂Win32 API
        [DllImport("user32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

        [DllImport("user32.dll")]
        private static extern bool IsIconic(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern uint GetWindowThreadProcessId(IntPtr hWnd, ref uint procId);

        // R[obN\bh̃fQ[g
        private delegate int EnumerateWindowsCallback(IntPtr hWnd, int lParam);

        [DllImport("user32", EntryPoint = "EnumWindows")]
        private static extern int EnumWindows(EnumerateWindowsCallback lpEnumFunc, int lParam);

        private static Process target_proc = null;
        private static IntPtr target_hwnd = IntPtr.Zero;

        // EBhE񋓂邽߂̃R[obN\bh
        public static int EnumerateWindows(IntPtr hWnd, int lParam)
        {
            uint procId = 0;
            uint result = GetWindowThreadProcessId(hWnd, ref procId);
            if (procId == target_proc.Id)
            {
                // IDŕ̃EBhEꍇ
                // Ƃ肠ŏ̃EBhE_ŏI
                target_hwnd = hWnd;
                return 0;
            }

            // 񋓂pɂ0ȊOԂKv
            return 1;
        }

        // OvZX̃EBhEőOʂɕ\
		public static void WakeupWindow(Process target)
		{
            target_proc = target;
            EnumWindows(new EnumerateWindowsCallback(EnumerateWindows), 0);
            if (target_hwnd == IntPtr.Zero)
            {
                return;
            }

			// CEEBhEŏĂΌɖ߂
			if (IsIconic(target_hwnd))
			{
				ShowWindowAsync(target_hwnd, SW_RESTORE);
			}

			// CEEBhEőOʂɕ\
			SetForegroundWindow(target_hwnd);
		}

        // ShowWindowAsync֐̃p[^ɓn`l
		private const int SW_RESTORE = 9;  // ʂ̑傫ɖ߂

		/// <summary>
        /// s̃vZXƓProcessNamevZX擾
		/// </summary>
		/// <returns></returns>
		public static Process GetPreviousProcess()
		{
			Process curProcess = Process.GetCurrentProcess(); 
            // ProcessName͎st@C.exe𔲂
			Process[] allProcesses = Process.GetProcessesByName (curProcess.ProcessName); 

			foreach (Process checkProcess in allProcesses) 
			{ 
				// g̃vZXID͖
				if (checkProcess.Id != curProcess.Id) 
				{
                    string prev = checkProcess.MainModule.FileName;
                    string cur = curProcess.MainModule.FileName;

					// vZX̃tpXrēAvP[V
					if (String.Compare(prev, cur, true) == 0)
					{
						// tpX̃vZX擾
						return checkProcess;
					}
				}  
			}

			// AvP[ṼvZXȂI  
			return null;  
		}
    }
}
