using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace TypingManager
{
    /// <summary>
    /// \Ot̃^Cv\
    /// </summary>
    public enum LineGraphType
    {
        StrokeNumPerMinute, // Ō^
        StrokeNumPerHour,   // Ō^
        StrokeNumPerDay,    // Ō^
        TypeSpeedPerStroke, // ŌxiŁ^j
    }

    public enum ProcessStrokeViewType
    {
        Today,
        All,
    }

    public class RequiredDll
    {
        public const string IRON_PYTHON = "IronPython.dll";
        public const string IRON_MATH = "IronMath.dll";
        public const string PLUGIN = "Plugin.dll";

        public static bool IsExists()
        {
            if (!File.Exists(IRON_PYTHON) || !File.Exists(IRON_MATH) || !File.Exists(PLUGIN))
            {
                return false;
            }
            return true;
        }
    }

    /// <summary>
    /// AvP[VŜ̐ݒۑNX
    /// </summary>
    public class AppConfig
    {
        /// <summary>uvZXʑŌv^uō̑ŌorׂĂ̑Ō̐؂ւ</summary>
        public ProcessStrokeViewType processViewType;

        /// <summary>Otɂ}[N</summary>
        public LineGraphMarkType markType;

        /// <summary>Ot̃^Cv</summary>
        public LineGraphType lineGraphType;

        /// <summary>ɎOɕ\邩ǂ</summary>
        public bool topMost;

        /// <summary>EBhE^Cgʂ̑Ōۑ邩ǂ</summary>
        public bool saveTitleStroke;

        /// <summary>IĂ^uԍ</summary>
        public int tabIndex;

        /// <summary>IɃOۑ邩</summary>
        public bool scheduleLogging;

        /// <summary>OۑԊuij</summary>
        public int scheduleTiming;

        /// <summary>ŌxOtőŌĂƔFĕ`悷鎞ԁibj</summary>
        public int noStrokeLimitTime;

        /// <summary>IɊmFbZ[Wo</summary>
        public bool showExitMessage;

        /// <summary>uIڂRs[v`</summary>
        public string selectedItemCopyFormat;

        /// <summary>ŌXgr[ENbNƂ̃Rs[`</summary>
        public string rightClickCopyFormat;

        /// <summary>WIȃtbNgitruȅꍇ_proxy.exegtbNj</summary>
        public bool standardHook;

        /// <summary>^[QbgEBhẼ^CgႤꍇ̂݃vZX擾</summary>
        public bool getAppPathByTitleChange;

        /// <summary>ŌԂL^ۂ̍ŒŌxi/j</summary>
        public int minStrokeTimeSpeed;

        /// <summary>ŌԂL^ۂ̍ōŌxi/j</summary>
        public int maxStrokeTimeSpeed;


        private static AppConfig __instance;

        #region vpeB...
        public static ProcessStrokeViewType ProcessViewType
        {
            get { return __instance.processViewType; }
            set { __instance.processViewType = value; }
        }
        public static LineGraphMarkType MarkType
        {
            get { return __instance.markType; }
            set { __instance.markType = value; }
        }
        public static LineGraphType LineGraphType
        {
            get { return __instance.lineGraphType; }
            set { __instance.lineGraphType = value; }
        }
        public static bool TopMost
        {
            get { return __instance.topMost; }
            set { __instance.topMost = value; }
        }
        public static bool SaveTitleStroke
        {
            get { return __instance.saveTitleStroke; }
            set { __instance.saveTitleStroke = value; }
        }
        public static int TabIndex
        {
            get { return __instance.tabIndex; }
            set { __instance.tabIndex = value; }
        }
        public static bool ScheduleLogging
        {
            get { return __instance.scheduleLogging; }
            set { __instance.scheduleLogging = value; }
        }
        public static int ScheduleTiming
        {
            get { return __instance.scheduleTiming; }
            set { __instance.scheduleTiming = value; }
        }
        public static int NoStrokeLimitTime
        {
            get { return __instance.noStrokeLimitTime; }
            set { __instance.noStrokeLimitTime = value; }
        }
        public static bool ShowExitMessage
        {
            get { return __instance.showExitMessage; }
            set { __instance.showExitMessage = value; }
        }
        public static string SelectedItemCopyFormat
        {
            get { return __instance.selectedItemCopyFormat; }
            set { __instance.selectedItemCopyFormat = value; }
        }
        public static string RightClickCopyFormat
        {
            get { return __instance.rightClickCopyFormat; }
            set { __instance.rightClickCopyFormat = value; }
        }
        public static bool StandardHook
        {
            get { return __instance.standardHook; }
            set { __instance.standardHook = value; }
        }
        public static bool GetAppPathByTitleChange
        {
            get { return __instance.getAppPathByTitleChange; }
            set { __instance.getAppPathByTitleChange = value; }
        }
        public static int MinStrokeTimeSpeed
        {
            get { return __instance.minStrokeTimeSpeed; }
            set { __instance.minStrokeTimeSpeed = value; }
        }
        public static int MaxStrokeTimeSpeed
        {
            get { return __instance.maxStrokeTimeSpeed; }
            set { __instance.maxStrokeTimeSpeed = value; }
        }
        #endregion

        private AppConfig()
        {
            // xmlSerializer̓RXgN^ĂяoĂ
            // XMLt@CɋLqĂlZbĝ
            // t@CȂꍇ̏lRXgN^ɏĂ
            lineGraphType = LineGraphType.TypeSpeedPerStroke;
            topMost = false;
            processViewType = ProcessStrokeViewType.Today;
            markType = LineGraphMarkType.None;
            saveTitleStroke = false;
            tabIndex = 0;
            scheduleLogging = true;
            scheduleTiming = 10;
            noStrokeLimitTime = 3;
            showExitMessage = false;
            selectedItemCopyFormat = "%1, %2, %3";
            rightClickCopyFormat = "%1 - [%2]";
            standardHook = true;
            getAppPathByTitleChange = true;
            minStrokeTimeSpeed = 100;
            maxStrokeTimeSpeed = 2000;
        }

        public static void Load(string filename)
        {
            if (File.Exists(filename))
            {
                //XmlSerializerIuWFNg̍쐬
                XmlSerializer serializer = new XmlSerializer(typeof(AppConfig));

                //t@CJ
                FileStream fs = new FileStream(filename,
                    FileMode.Open, FileAccess.Read, FileShare.Read);

                XmlReader reader = XmlReader.Create(fs);

                //XMLt@Cǂݍ݁AtVA
                __instance = (AppConfig)serializer.Deserialize(reader);

                //
                fs.Close();
            }
            else
            {
                __instance = new AppConfig();
            }
        }

        public static void Load()
        {
            AppConfig.Load(Plugin.LogDir.CONFIG_FILE);
        }

        public static void Save(string filename)
        {
            //XmlSerializerIuWFNg쐬
            //ރIuWFNǧ^w肷
            XmlSerializer serializer = new XmlSerializer(typeof(AppConfig));

            //t@CJ
            FileStream fs = new FileStream(filename, FileMode.Create);

            //VAAXMLt@Cɕۑ
            serializer.Serialize(fs, __instance);
            
            //
            fs.Close();
        }

        public static void Save()
        {
            Save(Plugin.LogDir.CONFIG_FILE);
        }
    }
}
