from PyQt4.QtCore import *
from PyQt4.QtGui import *
from extractionConfigDialog import *

class ExtractionTabFilter():
    def __init__(self, tabId, form, timeLineWidget):
        self.tabId = tabId
        self.form = form
        self.timeLineWidget = timeLineWidget
        self.tabName = ""

        self.nickExt = []
        self.nickMatchingType = 0
        self.nickCaseSesnsitivity = Qt.CaseInsensitive

        self.textExt = []
        self.textMatchingType = 0
        self.textCaseSesnsitivity = Qt.CaseInsensitive

        self.settings = QSettings("Twitturn")
        self.setVisible(True)
        self.loadSettings()

    def setTabName(self, tabName):
        self.tabName = tabName
        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.settings.setValue("tabName", QVariant(tabName))

        self.settings.endGroup()

    def setVisible(self, visible):
        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.settings.setValue("visible", QVariant(visible))

        self.settings.endGroup()

    def filter(self, post):
        for nick in self.nickExt:
            if stringCompare(
                    post.text(1),
                    nick, 
                    self.nickMatchingType,
                    self.nickCaseSesnsitivity):
                if self.timeLineWidget.addPost(post, True):
                    self.timeLineWidget.setNotify(True)
                    post.setForeground(
                            1, QBrush(QColor("darkmagenta")))
                    post.setForeground(
                            2, QBrush(QColor("darkmagenta")))
                    self.form.systemTrayIconMessageDictionary[
                            post.text(4)] =(
                            post.text(1) + ": " + post.text(2))
                return
        for text in self.textExt:
            if stringCompare(
                    post.text(2),
                    text, 
                    self.textMatchingType,
                    self.textCaseSesnsitivity):
                if self.timeLineWidget.addPost(post, True):
                    self.timeLineWidget.setNotify(True)
                    post.setForeground(
                            1, QBrush(QColor("darkblue")))
                    post.setForeground(
                            2, QBrush(QColor("darkblue")))
                    self.form.systemTrayIconMessageDictionary[
                            post.text(4)] =(
                            post.text(1) + ": " + post.text(2))
                return
    def loadSettings(self):
        if not self.settings.value("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1)+"/configured").toBool(): 
            return

        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.tabName = self.settings.value("tabName").toString()
        self.nickMatchingType = self.settings.value("comboBoxNick").toInt()[0]
        if self.settings.value("checkBoxNick").toBool():
            self.nickCaseSesnsitivity = Qt.CaseSensitive
        else:
            self.nickCaseSesnsitivity = Qt.CaseInsensitive

        self.nickExt = self.settings.value("textEditNick").toString().split(
                "\n", 
                QString.SkipEmptyParts)

        self.textMatchingType = self.settings.value("comboBoxText").toInt()[0]
        if self.settings.value("checkBoxText").toBool():
            self.textCaseSesnsitivity = Qt.CaseSensitive
        else:
            self.textCaseSesnsitivity = Qt.CaseInsensitive  
        self.textExt = self.settings.value("textEditText").toString().split(
                "\n",
                QString.SkipEmptyParts)

        self.settings.endGroup()

def stringCompare(s1, s2, matchingType=0, cs=Qt.CaseInsensitive):
    if matchingType==0:
        return s1 == s2
    elif matchingType==1:
        return s1.contains(s2, cs)
    elif matchingType == 2:
        return s1.startsWith(s2, cs)
    elif matchingType == 3:
        return s1.endsWith(s2, cs)
    elif matchingType == 4:
        return QRegExp(s2,cs,QRegExp.RegExp2).exactMatch(s1)
    elif matchingType == 5:
        return QRegExp(s2,cs,QRegExp.Wildcard).exactMatch(s1)

