from PyQt4.QtCore import *

class TwitturnShortcutKeyManager(QObject):
    def __init__(self):
        self.nameToFunctionTable = {}
        self.keyToFunctionTable = {}

    def addFunction(self, function, accessName):
        if accessName in self.nameToFunctionTable:
            return False
        self.nameToFunctionTable[accessName] = function
        return True
    def setShotrcutKey(self, accessName, key):
        if not accessName in self.nameToFunctionTable:
            return False
        self.keyToFunctionTable[key] = self.nameToFunctionTable[accessName]
        return True
    def keyToFunction(self, key):
        if not key in self.keyToFunctionTable:
            return None
        return self.keyToFunctionTable[key]

    def loadKeyConfigFile(self, fileName):
        splitter = QRegExp('\s*:\s*')
        keySplitter = QRegExp('\s*,\s*')

        file = QFile(fileName)
        if not file.open(QIODevice.ReadOnly | QIODevice.Text):
             return False

        inputStream = QTextStream(file);
        while not inputStream.atEnd():
            line = inputStream.readLine();
            entry = line.split(splitter)
            keys = entry[1].split(keySplitter, QString.SkipEmptyParts)
            for key in keys:
                self.setShotrcutKey(str(entry[0]), eval(str('Qt.Key_'+key)))
        return True
