from PyQt4.QtCore import *
from PyQt4.QtGui import *

class TwitturnTabWidget(QTabWidget):
    def __init__(self, parent=None):
        QTabWidget.__init__(self, parent)

        self.tabOpenButton = QToolButton(self)
        self.actionNewExtractionTab = QAction( 
                self.tr("New Extraction Tab"), self)
        self.actionNewExtractionTab.setIcon( 
                QIcon( QPixmap("images/tabopen.svg")))
        self.tabOpenButton.setDefaultAction(self.actionNewExtractionTab)
        self.tabOpenButton.setAutoRaise(True)
        self.setCornerWidget( self.tabOpenButton, Qt.TopLeftCorner)

        self.tabCloseButton = QToolButton(self)
        actionCloseTab = QAction( self.tr("Close Tab"), self)
        actionCloseTab.setIcon( QIcon( QPixmap("images/tabclose.svg")))
        self.connect(actionCloseTab, SIGNAL("triggered()"), 
                self.closeCurrentTab)
        self.tabCloseButton.setDefaultAction(actionCloseTab)
        self.tabCloseButton.setAutoRaise(True)
        self.setCornerWidget( self.tabCloseButton, Qt.TopRightCorner)

        self.connect( self, SIGNAL("currentChanged(int)"),
                self.changeCurrentTab)

    def changeCurrentTab(self, tabIdx):
        self.tabCloseButton.setEnabled( 
                self.currentWidget().isClosable())

    def closeCurrentTab(self):
        if self.currentWidget().isClosable():
            self.currentWidget().closeEvent(QCloseEvent())
            self.removeTab( self.currentIndex())
