from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtNetwork import *

class IconChacheManager(QObject):
    def __init__(self, *args):
        QObject.__init__(self, *args)

        self.http = QHttp()
        self.url = QUrl()
        self.iconChache = {}
        self.lastNetworkQueriedIconName = QString()

        self.settings = QSettings("Twitturn")

        self.connect(
                self.http, 
                SIGNAL("done(bool)"),
                self.readIconFromHttpResponse)

    def queryIcon(self, iconUrl, nick=QString()):
        iconName = self.urlToIconName(iconUrl, nick)
        if self.iconChache.has_key(iconName):
            self.emit(SIGNAL("iconReady(QIcon)"), self.iconChache[iconName])
            return 
        if self.settings.value("cache/useIconCache").toBool():
            if self.loadLocalIconImage(iconName) == True:
                self.emit(
                        SIGNAL(
                            "iconReady(QIcon)"), 
                            self.iconChache[iconName])
                return 
        self.lastNetworkQueriedIconName = iconName
        self.fetchRemoteIcon(iconUrl)
        return

    def urlToIconName(url, nick=QString()):
        url = QString(url)
        return nick+'_'+url.section('/', -2, -2)+'_'+url.section('/', -1)
    urlToIconName = staticmethod(urlToIconName)

    def iconNameToFileName(self, iconName):
        dirStr = self.settings.value("cache/iconCacheDirecotry").toString()
        return dirStr+iconName

    def fetchRemoteIcon(self, url):
        self.url.setUrl(url)
        self.http.setHost(self.url.host())
        self.http.get(str(self.url.encodedPath()))

    def loadLocalIconImage(self, iconName):
        fileName = self.iconNameToFileName(iconName)
        file = QFile(fileName)
        if not file.exists():
            return False
        self.iconChache[iconName] =  QIcon(fileName)
        return True

    def readIconFromHttpResponse(self, error):
        iconName = self.lastNetworkQueriedIconName
        if error or not self.http.lastResponse().statusCode() == 200:
            self.iconChache[iconName] = QIcon()
            self.emit(SIGNAL("iconReady(QIcon)"), self.iconChache[iconName])
            return
        file = None
        if self.settings.value("cache/useIconCache").toBool():
            file = QFile(self.iconNameToFileName(iconName))
        else:
            file = QTemporaryFile(iconName)
        if not file.open(QIODevice.WriteOnly):
            print "File open faild: " + QString(file.fileName()).toAscii()
            self.iconChache[iconName] = QIcon()
            self.emit(SIGNAL("iconReady(QIcon)"), self.iconChache[iconName])
            return
        file.write(self.http.readAll())
        fileName =file.fileName()
        file.close()
        icon = QIcon(QPixmap(fileName))
        print QString(fileName).toAscii()
        self.iconChache[iconName] = icon
        self.emit(SIGNAL("iconReady(QIcon)"), icon)

    def setProxy(self,
            host, port, username=QString(), password=QString()):
        self.http.setProxy(host, port, username, password)
