Imports System
Imports System.Text


Public Class RadixConvert

    ''' <summary>
    ''' CX^X֎~Ă܂B
    ''' </summary>
    Private Sub New()

    End Sub

#Region "Int16^UInt16^p̃\bhQ"

    ''' <summary>
    ''' 3`36i̐lInt16^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToInt16\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToInt16(ByVal s As String, ByVal radix As Integer) As Short

        Dim digit As ULong = ToUInt64(s, radix)
        CheckDigitOverflow(digit, Int16.MaxValue)
        Return CType(digit, Short)

    End Function

    ''' <summary>
    ''' 3`36i̐lUInt16^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToUInt16\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToUInt16(ByVal s As String, ByVal radix As Integer) As UShort

        Dim digit As ULong = ToUInt64(s, radix)
        CheckDigitOverflow(digit, UInt16.MaxValue)
        Return CType(digit, UShort)

    End Function

    ''' <summary>
    ''' UInt16^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As Short, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        Return ToString(CType(n, ULong), radix, uppercase)

    End Function

    ''' <summary>
    ''' UInt16^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As UShort, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        Return ToString(CType(n, ULong), radix, uppercase)

    End Function

#End Region

#Region "Int32^UInt32^p̃\bhQ"

    ''' <summary>
    ''' 3`36i̐lInt32^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToInt32\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToInt32(ByVal s As String, ByVal radix As Integer) As Integer

        Dim digit As ULong = ToUInt64(s, radix)
        CheckDigitOverflow(digit, Int32.MaxValue)
        Return CType(digit, Integer)

    End Function

    ''' <summary>
    ''' 3`36i̐lUInt32^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToUInt32\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToUInt32(ByVal s As String, ByVal radix As Integer) As UInteger

        Dim digit As ULong = ToUInt64(s, radix)
        CheckDigitOverflow(digit, UInt32.MaxValue)
        Return CType(digit, UInteger)

    End Function

    ''' <summary>
    ''' UInt32^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As Integer, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        Return ToString(CType(n, ULong), radix, uppercase)

    End Function

    ''' <summary>
    ''' UInt32^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As UInteger, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        Return ToString(CType(n, ULong), radix, uppercase)

    End Function

#End Region

#Region "Int64^UInt64^p̃\bhQ"

    ''' <summary>
    ''' 3`36i̐lInt64^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToInt64\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToInt64(ByVal s As String, ByVal radix As Integer) As Long

        Dim digit As ULong = ToUInt64(s, radix)
        CheckDigitOverflow(digit, Int64.MaxValue)
        Return CType(digit, Long)

    End Function

    ''' <summary>
    ''' 3`36i̐lUInt64^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToUInt64\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToUInt64(ByVal s As String, ByVal radix As Integer) As ULong

        ' `FbN
        CheckNumberArgument(s)
        CheckRadixArgument(radix)

        Dim curValue As ULong = 0                                       ' ϊ̐l
        Dim maxValue As ULong = CType(UInt64.MaxValue / CType(radix, ULong), ULong)   ' ől1O̐l

        ' l͂Đlɕϊ
        Dim num As Char         ' 1̐l
        Dim digit As Integer    ' 1̐l
        Dim length As Integer = s.Length
        For i As Integer = 0 To length - 1
            num = s(i)
            digit = GetDigitFromNumber(num)
            CheckDigitOutOfRange(digit, radix)

            ' radix|ƂɐlI[o[t[ȂOɃ`FbN
            CheckDigitOverflow(curValue, maxValue)
            curValue = curValue * CType(radix, ULong) + CType(digit, ULong)
        Next

        Return curValue

    End Function

    ''' <summary>
    ''' UInt64^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As Long, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        Return ToString(CType(n, ULong), radix, uppercase)

    End Function

    ''' <summary>
    ''' UInt64^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As ULong, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        ' `FbN
        CheckRadixArgument(radix)

        ' ĺu0v́Aǂ̐iłu0vɂȂ
        If n = 0 Then
            Return "0"
        End If

        Dim curValue As New StringBuilder(41)   ' ϊ̐l
        ' UInt64.MaxValue̐l3iŕ\41łB
        Dim curDigit As ULong = n               ' ̐l

        ' l͂Đlɕϊ
        Dim digit As ULong  ' 1̐l
        Do
            ' ԉ̂̐lo
            digit = curDigit Mod CType(radix, ULong)
            ' o1؂̂Ă
            curDigit = CType(curDigit / CType(radix, ULong), ULong)

            curValue.Insert(0, GetNumberFromDigit(CType(digit, Integer), uppercase))
        Loop While curDigit <> 0

        Return curValue.ToString()

    End Function

#End Region

#Region "Decimal^p̃\bhQ"

    ''' <summary>
    ''' 3`36i̐lDecimal^̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToDecimal\bhgĂB
    ''' {|̕0xȂǂ̃vtBbNXɂ͑ΉĂ܂B
    ''' ƂȂ鐔lɁAXy[XȂǂ̕܂߂ȂłB
    ''' </remarks>
    ''' <param name="s">l</param>
    ''' <param name="radix"></param>
    ''' <returns>l</returns>
    Public Shared Function ToDecimal(ByVal s As String, ByVal radix As Integer) As Decimal

        ' `FbN
        CheckNumberArgument(s)
        CheckRadixArgument(radix)

        Dim curValue As Decimal = 0                                         ' ϊ̐l
        Dim maxValue As Decimal = Decimal.MaxValue / CType(radix, Decimal)  ' ől1O̐l

        ' l͂Đlɕϊ
        Dim num As Char         ' 1̐l
        Dim digit As Integer    ' 1̐l
        Dim length As Integer = s.Length
        For i As Integer = 0 To length - 1
            num = s(i)
            digit = GetDigitFromNumber(num)
            CheckDigitOutOfRange(digit, radix)

            ' radix|ƂɐlI[o[t[ȂOɃ`FbN
            CheckDigitOverflow(curValue, maxValue)
            curValue = curValue * CType(radix, Decimal) + CType(digit, Decimal)
        Next

        Return curValue

    End Function

    ''' <summary>
    ''' Decimal^̐l3`36i̐lɕϊ܂B
    ''' </summary>
    ''' <remarks>
    ''' 2^8^10^16íAConvert.ToString\bhgĂB
    ''' |ɂ͑ΉĂ܂B
    ''' </remarks>
    ''' <param name="n">l</param>
    ''' <param name="radix"></param>
    ''' <param name="uppercase">啶itruejAifalsej</param>
    ''' <returns>l</returns>
    Public Overloads Shared Function ToString(ByVal n As Decimal, ByVal radix As Integer, ByVal uppercase As Boolean) As String

        ' `FbN
        CheckRadixArgument(radix)

        ' ĺu0v́Aǂ̐iłu0vɂȂ
        If n = 0 Then
            Return "0"
        End If

        Dim curValue As New StringBuilder(120)  ' ϊ̐l
        ' Decimal.MaxValue̐l3iŕ\120łB
        Dim curDigit As Decimal = n             ' ̐l

        ' l͂Đlɕϊ
        Dim digit As Decimal   ' 1̐l
        Do
            ' ԉ̂̐lo
            digit = curDigit Mod CType(radix, Decimal)
            ' o1؂̂Ă
            curDigit = curDigit / CType(radix, Decimal)

            curValue.Insert(0, GetNumberFromDigit(CType(digit, Integer), uppercase))
        Loop While curDigit <> 0

        Return curValue.ToString()

    End Function

#End Region

#Region "ŎgpĂ郁\bhQ"

    Private Shared Sub CheckNumberArgument(ByVal s As String)

        If s = Nothing OrElse s = String.Empty Then
            Throw New ArgumentException("l񂪎w肳Ă܂B")
        End If

    End Sub

    Private Shared Sub CheckRadixArgument(ByVal radix As Integer)

        If radix = 2 OrElse radix = 8 OrElse radix = 10 OrElse radix = 16 Then
            Throw New ArgumentException("2^8^10^16iSystem.ConvertNXgĂB")
        End If
        If radix <= 1 OrElse 36 < radix Then
            Throw New ArgumentException("3`36iɂΉĂ܂B")
        End If

    End Sub

    Private Shared Sub CheckDigitOutOfRange(ByVal digit As Integer, ByVal radix As Integer)

        If digit < 0 OrElse radix <= digit Then
            Throw New ArgumentOutOfRangeException("l͈͊OłB")
        End If

    End Sub

    Private Shared Sub CheckDigitOverflow(ByVal curValue As ULong, ByVal maxValue As ULong)

        If curValue > maxValue Then
            Throw New OverflowException("lől𒴂܂B")
        End If

    End Sub

    Private Shared Sub CheckDigitOverflow(ByVal curValue As Decimal, ByVal maxValue As Decimal)

        If curValue > maxValue Then
            Throw New OverflowException("lől𒴂܂B")
        End If

    End Sub

    Private Shared Function GetDigitFromNumber(ByVal num As Char) As Integer

        Dim ascNum As Integer = Asc(num)
        If ascNum >= Asc("0") AndAlso ascNum <= Asc("9") Then
            Return Asc(num) - Asc("0")
        ElseIf ascNum >= Asc("A") AndAlso ascNum <= Asc("Z") Then
            Return ascNum - Asc("A") + 10
        ElseIf ascNum >= Asc("a") AndAlso ascNum <= Asc("z") Then
            Return ascNum - Asc("a") + 10
        Else
            Return -1
        End If

    End Function

    Private Shared Function GetNumberFromDigit(ByVal digit As Integer, ByVal uppercase As Boolean) As Char

        If digit < 10 Then
            Return Chr(Asc("0") + digit)
        ElseIf uppercase Then
            Return Chr(Asc("A") + digit - 10)
        Else
            Return Chr(Asc("a") + digit - 10)
        End If

    End Function

#End Region

End Class

