#ifndef TSREMUXCPP_FORM1_H_
#define TSREMUXCPP_FORM1_H_

#include <string>
#include <time.h>
#include "Utils.h"

namespace TsRemux {
enum SaveState {
	Remux,
	DemuxSup,
	DemuxStream,
	DemuxPes
};
	
class ExecCondition {
 public:
  ExecCondition(void);
  ~ExecCondition(void);
  void tl_MouseLeave();
  void tl_MouseEnter();
  pByte input_file_text_;
  bool use_async_io_;
  bool bypass_audio_processing_;
  bool mip_to_ac3_;
  bool keep_con_open_;
  pByte	output_file_text_;
  bool m2ts_format_;
  bool ts_format_;
  bool bluray_format_;
};

class TsRemux {
 public:
  TsRemux(int argc, char *argv[]);
  ~TsRemux(void);
  int Exec(void);

 private:
  TsRemux(void);
  void say(std::string txt);
  void Init(void);
  void DisableNumerics(void);
  void DisableSup(void);
  void EnableSup(void);
  void EnableNumerics(void);
  void OpenFile(std::string filename);
  void OpenInputFileDialog_FileOK();
  void AsyncOpenFile(std::string filename);
  void InputFileBrowseButton_Click();
  void EnableCbxMlp(void);
  void ElementaryStreamListBox_ItemCheck();
  void Quit_Click();
  void RemuxButton_Click();
  void backgroundWorker1_DoWork();
  void backgroundWorker1_ProgressChanged();
  void backgroundWorker1_RunWorkerCompleted();
  void RemuxButton_MouseEnter();
  void RemuxButton_MouseLeave();
  void TsRemux_DragDrop();
  void TsRemux_DragEnter();
  void TrimStartNumericHours_ValueChanged();
  void TrimStartNumericMinutes_ValueChanged();
  void TrimStartNumericSeconds_ValueChanged();
  void TrimEndNumericHours_ValueChanged();
  void TrimEndNumericMinutes_ValueChanged();
  void TrimEndNumericSeconds_ValueChanged();
  void CheckTrimStart(void);
  void CheckSupStart(void);
  void CheckChapterLen(void);
  void CheckTrimEnd(void);
  void ElementaryContextMenu_Opening();
  void AddStream_Click();
  void RemoveStream_Click();
  void DemuxElementary_Click();
  void DemuxPes_Click();
  void DemuxSup_Click();
  void SaveElementaryStream_FileOK();
  void RemoveSup(void);
  void OpenSupFileDialog_FileOK();
  bool PidExist(ushort pid);
  void SupOffsetNumericSeconds_ValueChanged();
  void SupOffsetNumericMinutes_ValueChanged();
  void SupOffsetNumericHours_ValueChanged();
  void TsFormatRadioButton_CheckedChenged();
  void M2tsFormatRadioButton_CheckedChanged();
  void backgroundWorker2_Dowork();
  void backgroundWorker2_ProgressChanged();
  void backgroundWorker2_RunWorkerCompleted();
  int argc_;
  pByte argv_;
  ExecCondition exec_condition_;
  TimeSpan trim_start_;
  TimeSpan sup_start_;
  TimeSpan chapter_len_;
  TimeSpan trim_end_;
  bool sup_selected_;
};

}  //namespace

#endif

