<?php 
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

if (!isset($length)) {
	$length = 76;
}

?>
<div class="SimpleBox<?php if (isset($class)): ?> <?php echo $class ?><?php endif ?>" id="Link_index">
<div class="innerBox smallInnerBox">
<div class="box full">

<div class="boxHeader">
<h3>
<?php 
if (isset($box_title)) {
	echo $box_title;
} else {
	$key = array_search($name, $model_type);
	if ($key !== false) {
		echo $linkSelect->get_i18n_type($key, $type);
	}
}

echo $this->Html->tag('span',  
	$this->Html->link(__(' ...More', true), array(
		'controller' => 'links',
		'action' => 'listview',
		'plugin' => 'links',
		$key
	), array(
	))
);

?></h3>
<?php if ((isset($showDescription) && !empty($showDescription)) && (isset($type[$key]['description']) && !empty($type[$key]['description']))): ?>
<h4><?php echo $type[$key]['description'] ?></h4>
<?php endif ?>
</div>
<div class="boxBody">
<?php if (!empty($links[$name])): ?>
<table class="recentLink">
<?php foreach($links[$name] as $k => $link) : ?>
<tr>
<?php
$url = array(
	'controller' => 'links',
	'action' => 'visit',
	'plugin' => 'links',
	$link['Link']['id']
);

echo $this->element('link_box_td', array(
	'link' => $link,
	'url' => $url,
	'length' => $length,
));
?>
</tr>
<?php endforeach; ?>
</table>
<?php endif; ?>
</div>
<div class="boxFooter"><?php if (isset($footer)): ?><?php echo $footer; ?><?php endif; ?></div>
</div>

</div>
</div>
