<?php
/**
 * Link Plugin for TRPG Databank
 * バナー画像表示用
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

/*表示のデフォルト設定 */
$default_options = array(
	'previewVersion' => 'banner',
	'class' => 'linkBanner',
	'url' => '',
	'alternative' => '',
	'model_name' => 'Link',
	'mime_type' => 'original',
	'nodata' => '',
	'htmlAttributes' => array(
		'target' => '_blank',
	),
);
?>

<?php
if (!isset($basename) && !isset($attachment)) {
	$basename = '';
}
if (!isset($options)) {
	$options = array();
}

// 画像パス取得
$options = array_merge_recursive($default_options, $options);

if (isset($attachment)) {
	$file = $upfile->get_charaimage_version_path4attachment($attachment, $options);
} else {
	$file = $upfile->get_cet_charaimage_version4basename($basename, $options);
}

$bg_file = $media->url($file, true);

if (!isset($options['htmlAttributes'])) {
	$options['htmlAttributes'] = array();
}
$options['htmlAttributes'] = array_merge(
	$options['htmlAttributes'],
	array('escape' => false),
	array('class' => $options['class']),
	array('style' => 'background-image: url('.$bg_file.');')
);

if (isset($name) && !empty($name)) {
	$description = $html->tag(
		'span', 
		$name, 
		array(
//			'style' => 'display: none;',
		)
	);
} else {
	$description = null;
}

// 画像リンク出力
echo $html->link(
	$description,
	$options['url'],
	$options['htmlAttributes'],
	false
);

