<div class="systems form delete">
<?php echo $form->create('System', array(
	'url' => array(
		'controller' => 'systems',
		'action' => 'admin_delete',
		$system['System']['id']
	),
));
?>
<fieldset>
<legend><?php echo sprintf(__('Are you sure you want to delete %s?', true), $system['System']['name']); ?></legend>

<?php 
	echo $html->div(
	'notice',
	sprintf(__('ALL PROFILE data belonging %s will be deleted. OK?', true), $system['System']['name'])
	);

	echo $form->input('confirm', array(
		'type' => 'hidden',
		'value' => 'yes'
	));
 ?>

<div class="system_data">
<?php
	$system_name = $system['System']['name'];

	$url = null;
	if ($system['System']['url']) {
		$url = $system['System']['url'];
	}
	$file = $upfile->file(
		'xs', 
		CorePlus::get_value($system, 'Attachment.0'),
		array(
			'model_name' => 'System', 
			'mime_type' => 'original',
			'nodata' => 'image',
		)
	);
	$system_img = $upfile->embed(
		$file,
		array(
			'alt' => CorePlus::get_value($system, 'Attachment.0.alternative'),
			'restrict' => array('image'),
			'htmlAttributes' => array(
				'target' => '_blank',
			),
		)
	);

	$public = $html->tag('span', 
		$select->get_i18n_public_flag($system['System']['public_flag'], $public_flags),
		array(
			'class' => 'text publicFlag',
		)
	);
/*	if ($system['System']['set_npc']) {
		$npc_status = __('NPC Setting: Use', true);
	} else {
		$npc_status = __('NPC Setting: No Use', true);
	}
	$npc_use = $html->tag('span', 
		$npc_status,
		array(
			'class' => 'text',
		)
	);*/

	$footer = null;

	echo $this->element('box', array(
		'header' => $system_img. $system_name. $public. $npc_use,
		'body' => $system['System']['detail']."&nbsp;",
		'footer' => $footer,
	));
?>
</div>

<div class="characters">
<?php
	$total =  $html->tag('span', sprintf(__('Total Characters %d', true), $system['System']['character_num']), array('class' => 'total_chara_num'));

	echo $this->element('character_picture_table', array(
		'header' => __('Characters', true). $total,
		'characters' => $system['Character'],
		'previewVersion' => 'xs',
		'colNum' => 15,
		'id' => null,
		'isUser' => false,
		'isCharacter' => false,
		'isSystem' => false,
		'isModified' => false,
	));
?>
</div>

<?php
	echo $token->create();
?>
</fieldset>
<?php echo $form->end(array('label' => __('Submit', true)));?>
</div>

<div class="backButton">
<?php
	echo $form->create('', array('url' => array(
		'controller' => 'systems', 'action' => 'admin_view', $system['System']['id']),
		'type' => 'GET',
		'id' => 'CancelButton'
	));
	echo $form->end(array('label' => __('Cancel', true)));
?>
</div>

