<?php
/*
 * @filesource
 * @copyright
 * @link
 * @package
 * @since
 * @version
 * @license
 */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<?php echo $html->charset('utf-8'); ?>
<meta http-equiv="X-UA-Compatible" content="IE=7">

<meta name="robots" content="<?php echo $site_configs['Site.robots']['value'] ?>">
<meta name="keywords" content="<?php echo $site_configs['Site.keywords']['value'] ?>">
<meta name="description" content="<?php echo str_replace(array("\n", "\r"), '', $site_configs['Site.siteDescription']['value']) ?>">
<title>
<?php
if (isset($site_configs['Site.siteName'])) {
	echo $settings->value4key_name($site_configs, 'Site.siteName');
} else {
	echo "&nbsp;";
}
?>
<?php echo $title_for_layout; ?>
</title>
<?php
	//echo $html->meta('icon'); // スキン設定etcで管理画面変更対応予定
	echo $html->css('cake.generic');
	echo $html->css('base');
	echo $html->css('box');
	echo $html->css('layout');
	if (!isset($this->theme)) {
		echo $html->css('character-sheet');
	} else {
		echo $html->css('character-sheet-skins');
	}

	// Javascript
	// jQuery
	echo $this->Html->script('jquery-1.5.min.js');
	echo $this->Html->script('jquery-ui-1.7.2.custom.min.js');
	// 独自ライブラリ
	// Cacheから取得
	echo $this->Js->writeBuffer();
	// readyイベント
?>

<!--[if IE ]>
<?php
	echo $html->css('ie');
?>
<![endif]-->
<!--[if lte IE 6 ]>
<?php
	echo $html->css('ie6');
?>
<![endif]-->

<style type="text/css">
<!--
<?php 
echo $site_configs['Design.customCss']['value'];
 ?>
-->
</style>

<?php echo $scripts_for_layout; ?>

</head>
<body id="<?php echo $this->name; ?>_<?php echo $this->action; ?>">
<div id="container">

<?php
echo $this->element('insert_html', array(
	'place' => 'pageTop',
));
?>

<?php if (!isset($site_configs) || !isset($user)): ?>
<?php echo $session->flash('auth'); ?>
<?php echo $session->flash(); ?>
<?php echo $content_for_layout; ?>
<?php else: ?>

<div id="header">
<?php 
echo $this->element('pc_header_intro', array(
	'site_configs' => $site_configs,
	));
?>

<div class="mainNavi">
<ul id="nav" class="navi">
<?php if ($this->action != 'regist_end'): ?>
<?php if (isset($site_configs['Site.outerHome']['value']) && $site_configs['Site.outerHome']['value']): ?>
	<li><?php echo $html->link($site_configs['Site.outerHomeLinkname']['value'], $site_configs['Site.outerHome']['value']); ?>
<?php endif; ?>

<?php if (!empty($site_configs['Site.myHome']['value'])): ?>
	<li><?php echo $html->link(__('Home', true), '/users/index'); ?>

	<li><?php echo $html->link(__('Character List', true), array('controller' => 'characters', 'action' => 'index')); ?></li>
<?php else: ?>
	<li><?php echo $html->link(__('Character List', true), array('controller' => 'characters', 'action' => 'index')); ?></li>
<?php endif; ?>

<?php if (isset($site_configs['System.singleSystem']['value']) && !$site_configs['System.singleSystem']['value']): ?>
	<li><?php echo $html->link(__('Systems', true), array('controller' => 'systems', 'action' => 'index')); ?></li>
<?php endif; ?>

<?php if (empty($site_configs['Site.myHome']['value'])): ?>
	<li><?php echo $html->link(__('My Home', true), '/users/index'); ?>
<?php endif; ?>

<?php endif; ?>
</ul>
<ul id="navAdmin" class="navi">
<cake:nocache>
<li>
<?php if ($session->read('Auth.User')): ?>
<?php echo $html->link(__('Logout', true), array('controller' => 'users', 'action' => 'logout')); ?>
<?php else: ?>
<?php echo $html->link(__('Login', true), array('controller' => 'users', 'action' => 'login')); ?>
<?php endif; ?>
</li>

<?php if (in_array($session->read('Auth.User.group_id'), array(1,2,3))): ?>
<li>
<?php echo $html->link(__('Administration', true), Configure::read('Routing.adminBasePath')); ?>
</li>
<?php endif; ?>
</cake:nocache>
<?php if (!empty($site_configs['Info.help']['value'])): ?>
<li>
<?php 
echo $html->link(__('Help', true), array(
	'controller' => 'site_configs',
	'action' => 'view',
	'help',
), array(
	'target' => 'help',
));
?>
</li>
<?php endif; ?>
</ul>

</div>
</div>
<div id="content">

<div id="subNavi">
<?php
switch ($this->params["controller"]) {
	case 'users':
		switch ($this->params["action"]) {
			case 'index':
			case 'edit':
			case 'edit_image':
			case 'change_password':
			case 'delete':
				if ($user['User']['id']) {
					echo $this->element('sidenav_config', array());
				} else {
					echo $this->element('sidenav_user', array());
				}
				break;
			default:
				echo $this->element('sidenav_user', array());
				break;
		}
		break;
	case 'regist_mails':
	case 'send_mails':
			if ($user['User']['id']) {
				echo $this->element('sidenav_config', array());
			} else {
				echo $this->element('sidenav_user', array());
			}
	break;
	case 'systems':
	case 'character_sheets':
		if (!$site_configs['System.singleSystem']['value']) {
			echo $this->element('sidenav_system', array());
		}
		break;
	case 'characters':
	case 'character_profile_archives':
	case 'character_pictures':
		echo $this->element('sidenav_character', array());
		break;
	default:
		echo null;
		break;
}
?>
</div>

<?php
echo $this->element('insert_html', array(
	'place' => 'naviBottom',
));
?>

<?php echo $session->flash('auth'); ?>
<?php echo $session->flash(); ?>
<?php echo $content_for_layout; ?>
</div>
<?php endif; ?>


<?php
if (isset($character['System']['copyright'])) {
	$copyright = $character['System']['copyright']; 
} elseif (isset($system['System']['copyright'])) {
	$copyright = $system['System']['copyright']; 
} elseif (isset($this_system['System']['copyright'])) {
	$copyright = nl2br($this_system['System']['copyright']); 
} elseif (isset($characterSheets['System']['copyright'])) {
	$copyright = nl2br($characterSheets['System']['copyright']); 
} else {
	$copyright = null;
}

echo $this->element('footer', array(
	'system_copyright' => $copyright,
	'isAdmin' => false,
));
?>

<?php
echo $this->element('insert_html', array(
	'place' => 'pageBottom',
));
?>

</div>
</body>
</html>