<div class="characterSheets form">
<?php 
	$url = array(
		'controller' => 'character_sheets',
		'action' => 'add',
	);
	if (isset($this_system['System']['id'])) {
		$url[] = $this_system['System']['id'];
	} 
	echo $form->create('CharacterSheet', array('url' => $url));

?>
<fieldset>
<legend><?php __('Add CharacterSheet');?></legend>

<?php
	if (isset($this_system['System']['id'])) {
		echo '<div class="input select">';
		echo '<label for="CharacterSheetSystemId">'. __('System').'</label>';
		echo $systems[$this_system['System']['id']];
		echo '</div>';
	} else {
		echo $form->input('system_id', array(
			'label' => __('System', true),
			'after' => $html->tag(
				'div',
				__('No Editable', true),
				array('class' => 'required')
			)
		));
	}

	echo $form->input('name', array(
		'type' => 'text',
		'label' => __('Name', true).
			$html->tag(
				'span',
				__(' required', true),
				array('class' => 'required')
			),
		'after' => $html->tag(
			'div',
			sprintf(__('Less than %d characters', true), 64),
			array('class' => 'attention')
		)
	));


	echo $form->input('key_name', array(
		'type' => 'text',
		'label' => __('Key Name', true).
			$html->tag(
				'span',
				__(' required', true),
				array('class' => 'required')
			),
		'style' => 'ime-mode:inactive;',
		'after' => 
		$html->tag(
			'div',
			__('No Editable', true),
			array('class' => 'required')
		).
		$html->tag(
			'div',
			__('Only Number, Small letter and Underline.', true),
			array('class' => 'attention')
		).
		$html->tag(
			'div',
			sprintf(__('Less than %d characters', true), 40),
			array('class' => 'attention')
		)
	));
	echo $select->create_publicflag_select($public_flags, 'public_flag', array(
		'label' => __('Public Flag', true),
		'default' => 2,
	));

	echo $form->input('sort_order', array(
		'label' => __('Order', true),
		'style' => 'ime-mode:inactive;',
	));

	echo $token->create();
?>
</fieldset>
<?php echo $form->end(array('label' => __('Submit', true)));?>
</div>

<div class="backButton">
<?php
$url['action'] = 'index';
echo $form->create('', array(
	'url' => $url,
	'type' => 'GET',
));
echo $form->end(array('label' => __('Cancel', true)));
?>
</div>


