<?php 
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
?>
<div class="links form">
<?php 
	echo $form->create('Link', array(
		'url' => $url,
		'type' => 'file',
	));
?>
<fieldset>
<legend><?php if (!$isEdit): ?><?php __('Add Link'); ?><?php else: ?><?php __('Edit Link'); ?><?php endif ?></legend>
<?php
	echo $this->Form->input('url', array(
		'type' => 'text',
		'label' =>  __('URL', true),
		'style' => 'ime-mode:inactive;',
		'class' => 'longInput',
		'after' => $html->div(
			'required',
			__(' required', true)
		)
	));

	echo $this->Html->div(
		'attention', 
		 __('URL must be less than 512 letters. The Multi-byte letters will counted after UTF-8 encoded.', true)
	);

	echo $this->element('medium_edit', array(
		'label' => __('Banner', true),
		'noCaption' => true,
		'plugin' => 'media',
		'previewVersion' => 'banner',
		'class' => 'banner',
	));

	echo $this->Html->div(
		'attention', 
		 __('Recommended size is 88x31px.', true)
	);

	echo $this->Form->input('title', array(
		'type' => 'text',
		'label' =>  __('Title', true),
		'class' => 'longInput',
		'after' => $html->div(
			'',
			__('If empty, the site title will be automatically inputted.', true)
		)
	));

	echo $this->Form->input('notes', array(
		'type' => 'textarea',
		'label' => __('Description', true)
	));

	echo $linkSelect->create_type_select($type);

if ($isAdmin) {
	echo $select->create_boolean_select('pickup', array(
		'label' => __('PickUp', true),
		'default' => 0,
	));

	echo $form->input('ring', array(
		'label' => __('Ring text', true),
		'after' => $html->tag('div',
			__('HTML tags OK. It is for RING Tags setting.', true),
			array('class' => 'attention')
		)
	));
}

	echo $token->create();
?>
</fieldset>
<?php echo $this->Form->end(__('Submit', true));?>
</div>

<div class="backButton">
<?php
	echo $form->create('', array('url' => array(
			'plugin' => 'links',
			'controller' => 'links',
			'action' => 'listview',
		), 
		'type' => 'GET', 
		'id' => 'CancelButton'
	));
	echo $form->end(array('label' => __('Cancel', true)));
?>
</div>
