<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class Profile extends AppModel {

	var $name = 'Profile';

	var $fields = array(
		'add' => array('system_id', 'name', 'key_name', 'profile_type', 'all_public', 'required', 'show_list', 'search', 'sort_order'),
		'edit' => array('name', 'key_name', 'profile_type', 'all_public', 'required', 'show_list', 'search', 'sort_order'),
		'edit_all' => array('all_public', 'required', 'show_list', 'search','sort_order'),
		'escape' => array(
			'name' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
		),
	);

	var $validate = array(
		'name' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 255),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'key_name' => array(
			'keyNameNg' => array(
				'rule' => 'keyNameNg',
			),
			'keyName' => array(
				'rule' => 'keyName',
			),
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'profile_type' => array(
			'profileType' => array(
				'rule' => 'profileType',
				'allowEmpty' => true,
			),
		),
		'all_public' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
		'required' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
		'show_list' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
		'search' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'System' => array(
			'className' => 'System',
			'foreignKey' => 'system_id',
			'conditions' => '',
			'fields' => array('id', 'name'),
		)
	);

	var $hasMany = array(
		'ProfileSelect' => array(
			'className' => 'ProfileSelect',
			'foreignKey' => 'profile_id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
//			'order' => array('ProfileSelect.sort_order' => 'asc'), // Using filesortの原因
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'ProfileTable' => array(
			'className' => 'ProfileTable',
			'foreignKey' => 'profile_id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
//			'order' => array('ProfileTable.sort_order' => 'asc'),
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'CharactersHasProfile' => array(
			'className' => 'CharactersHasProfile',
			'foreignKey' => 'profile_id',
			'associationForeignKey' => 'id',
			'dependent' => true,
			'conditions' => '',
			'fields' => array(
				'CharactersHasProfile.id',
				'CharactersHasProfile.character_id',
				'CharactersHasProfile.profile_table_id',
				'CharactersHasProfile.profile_table_static_id',
				'CharactersHasProfile.value',
				'CharactersHasProfile.public_flag',
				'CharactersHasProfile.link_value',
			),
			'order' => array('CharactersHasProfile.id' => 'asc'),
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		),
		'DefaultProfile' => array(
			'className' => 'DefaultProfile',
			'foreignKey' => 'profile_id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
			'order' => array('DefaultProfile.id' => 'asc'),
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	/* validation Rule */

	/* 同システム中に同じkey_nameは不可 */
	function isUniqueKeyname4system($data, $system_id, $id = null) 
	{
		$params = array(
			'conditions' => array(
				'Profile.system_id' => $system_id,
				'Profile.key_name' => $data['key_name'],
			),
			'recursive' => -1,
		);

		if($id) {
			$params['conditions']['Profile.id !='] = $id;
		}

		return !($this->find('count', $params));
	}

	/* プロフィールの入力型 */
	function profileType($data) 
	{
		$profile_type = CorePlus::get_profile_types();
		if (isset($data['profile_type']) && in_array($data['profile_type'], $profile_type)) {
			return true;
		} else {
			return false;
		}
	}

	/* コールバックメソッド */
	function beforeSave($options = array())
	{
		if (empty($this->data['Profile']['sort_order'])) {
			$this->data['Profile']['sort_order'] = 0;
		}

		return parent::beforeSave($options);
	}

	function afterSave($created) {
		$this->deleteCache4Profile();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4Profile();

		return parent::afterDelete();
	}

	/* キャッシュ削除 */
	function deleteCache4Profile()
	{
		if (!isset($this->Character)) {
			$this->Character = CorePlus::set_model('Character');
		}
		$this->Character->cacheDelete();

		if (!isset($this->System)) {
			$this->System = CorePlus::set_model('System');
		}
		$this->System->cacheDelete();
	}

}
