<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileSelectsController extends AppController {

	var $name = 'ProfileSelects';
	var $helpers = array(
		'Profiledisp',
	);

	// POSTのTokenチェックをしないアクション
	var $disableTokenActions = array();

	function admin_listview($profile_id = null) {
		if (!$profile_id ) {
			$this->Session->setFlash(__('Invalid Profile', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->get_profile4profile_id($profile_id);
		if (empty($profile)) {
			$this->Session->setFlash(__('Invalid Profile', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		// 「その他」システム設定
		$this->checkEditOtherSystem($profile['Profile']['system_id']);

		if (isset($this->data['ProfileSelect']) || !empty($this->data['ProfileSelect'])) {

			$error = false;

			$i = 0;
			foreach ($this->data['ProfileSelect'] as $id => $v) {
				if ($id == '__Token' || !$id) {
					continue;
				}

				$profileSelect = $this->ProfileSelect->find('first', array(
					'conditions' => array(
						'ProfileSelect.id' => $id,
						'ProfileSelect.profile_id' => $profile_id,
					),
					'contain' => array(
						'Profile'
					),
					'recursive' => 1,
				));
				$this->check_profile_type($profileSelect);

				// 削除
				if (isset($v['value']) && empty($v['value'])) {
					if ($this->ProfileSelect->delete($id)) {
					} else {
						$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
						$error = true;
					}

				// 編集
				} else {
					$data['ProfileSelect'] = array(
						'value' => $v['value'],
						'sort_order' => $v['sort_order'],
					);

					$this->ProfileSelect->id = $id;
					$this->ProfileSelect->set($data);
					if ($this->ProfileSelect->validates()) {
						if ($this->ProfileSelect->save($data, array('fieldList' => $this->ProfileSelect->fields['edit_all']))) {
						} else {
							$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
							$error = true;
						}
					} else {
						$validate_errors = $this->ProfileSelect->invalidFields();
						$this->Session->setFlash(array_pop($validate_errors));

						$error = true;
					}

					$profile['ProfileSelect'][$i] = $v;
					$profile['ProfileSelect'][$i]['id'] = $id;
					$profile['ProfileSelect'][$i]['profile_id'] = $profile_id;
					$i++;
				}
			}

			if (!$error) {
				// 追加
				$newdata = $this->data['ProfileSelect'][0];
				unset($this->data['ProfileSelect'][0]);
				if (isset($newdata['value']) && !empty($newdata['value'])) {
					$data['ProfileSelect'] = array(
						'profile_id' => $profile_id,
						'value' => $newdata['value'],
						'sort_order' => $newdata['sort_order'],
					);

					$this->ProfileSelect->create();
					if ($this->ProfileSelect->validates()) {
						if ($this->ProfileSelect->save($data, array('fieldList' => $this->ProfileSelect->fields['add']))) {
						} else {
							$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
						}
					}
				}

				$this->Session->setFlash(__('The ProfileSelect has been saved', true));
				$this->redirect(array('controller' => 'profile_selects', 'action'=>'admin_listview', $profile_id));
			}

			unset($this->data['ProfileSelect']['__Token']);
		} else {
			foreach ($profile['ProfileSelect'] as $k => $v) {
				$profile['ProfileSelect'][$k] = $this->_restore_html_profile_select($v);
			}
		}

		$this->set('profile', $profile);

		$this->set('title_for_layout', " - ". __('ProfileSelects', true));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for ProfileSelect', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profileSelect = $this->ProfileSelect->read(null, $id);
		$this->check_profile_type($profileSelect);

		if ($this->ProfileSelect->delete($id)) {
			$this->Session->setFlash(sprintf(__('%s was deleted.', true), $profileSelect['ProfileSelect']['value']));
		} else {
			$this->Session->setFlash(__('The data has not been deleted', true));
		}
		$this->redirect(array('action'=>'admin_listview', $profileSelect['Profile']['id']));
	}

	/* 共通関数 */
	function _restore_html_profile_select($data, $nl2br = false) {
		$data['value'] = $this->{$this->modelClass}->restore_html($data['value'], true);

		return $data;
	}

	function get_profile4profile_id($profile_id)
	{
		if (!$profile_id) {
			$this->Session->setFlash(__('Invalid ProfileSelect.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->ProfileSelect->Profile->find('first', array(
			'conditions' => array(
				'Profile.id' => $profile_id,
			),
			'contain' => array(
				'System',
				'ProfileSelect',
			),
		));

		if ($this->check_profile_type($profile)) {

			foreach ($profile['ProfileSelect'] as $k => $v) {

				if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
					$sort_order[$k] = $v['sort_order'];
				} else {
					$sort_order[$k] = 0;
				}
			}
			if (!empty($sort_order)) {
				$profile['ProfileSelect'] = $this->sort4sort_order($profile['ProfileSelect'], $sort_order);
			}

			return $profile;
		}
	}
	function check_profile_type($profile)
	{
		if (!isset($profile['Profile']) || empty($profile['Profile'])) {
			$this->Session->setFlash(__('Invalid ProfileSelect.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		App::import('Helper', 'Profiledisp');
		$Profiledisp = new ProfiledispHelper;
		$Profiledisp->set_profile_type4view($profile['Profile']);

		if (!$Profiledisp->profile_type['is_select'] && !$Profiledisp->profile_type['is_radio'] && !$Profiledisp->profile_type['is_checkbox']) {
			$this->Session->setFlash(__('Profile type is not valid.', true));
			$this->redirect(array('controller' => 'profiles', 'action'=>'admin_edit', $profile['Profile']['id']));
		}

		return true;
	}

}
?>