<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class NewsController extends AppController {

	var $name = 'News';
	var $helpers = array(
		'Group',
		'Select',
		'Time',
	);

	// listView用のpagenate設定
	var $paginate = array(
		'conditions' => array(
			'News.public_flag' => 1,
		),
		'fields' => array(
			'News.id',
			'News.title',
			'News.value',
			'News.date',
			'News.end_date',
			'News.modified',
		),
		'recursive' => -1,
		'limit' => 20,
		'order' => array(
			'News.date' => 'desc'
		),
	);


	function beforeFilter() {

		parent::beforeFilter();

		// Cache
		$this->cacheAction = array(
			'view' => Configure::read('Cache.expireLong'),
			'index' => Configure::read('Cache.expireLong'),
		);

		// 認証なしアクセス可
		$this->AuthPlus->allow('index');
		$this->AuthPlus->allow('view');

		// 設定
		$this->set_public_flag4view();
	}

	/* アクション */
	function index() {
		$this->_index(false);
	}

	function view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid ID', true));
			$this->redirect(array('action' => 'index'));
		}

		$news = $this->News->find('first', array(
			'conditions' => array(
				'News.id' => $id
			),
			'fields' => '',
			'recursive' => -1,
		));
		if (empty($news)) {
			$this->Session->setFlash(__('Invalid news', true));
			$this->redirect(array('action' => 'index'));
		}

		$news['News'] = $this->_restore_html_news($news['News'], true);
		$this->set('news', $news);


		$this->set('title_for_layout', " - ". __('News', true). " ". $news['News']['title']);

	}

	function admin_index() {
		$this->_index(true);
	}

	function admin_add() {
		if (!empty($this->data)) {
			$this->News->create();
			if ($this->News->save($this->data, array('fieldList' => $this->SendMail->fields['add'], 'validate' => false))) {
				$this->Session->setFlash(__('The news has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The news could not be saved. Please, try again.', true));
			}
		}

		$this->set('title_for_layout', " - ". __('Add News', true));
	}

	function admin_edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid news', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->News->save($this->data)) {
				$this->Session->setFlash(__('The news has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The news could not be saved. Please, try again.', true));
				$this->data['News']['id'] = $id;
			}
		}
		if (empty($this->data)) {
			$news = $this->News->find('first', array(
				'conditions' => array(
					'News.id' => $id
				),
				'fields' => '',
				'recursive' => -1,
			));
			if (empty($news)) {
				$this->Session->setFlash(__('Invalid news', true));
				$this->redirect(array('action' => 'index'));
			}

			$news['News'] = $this->_restore_html_news($news['News'], true);

			$this->data = $news;
		}

		$this->set('title_for_layout', " - ". __('Edit News', true));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Id.', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->News->delete($id)) {
			$this->Session->setFlash(__('News deleted', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('News was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}

	function _index($isAdmin = false)
	{
		$this->set('isAdmin', $isAdmin);

		if ($isAdmin) {
			unset($this->paginate['conditions']['News.public_flag']);

			$this->paginate['fields'] = '';
		}

		$news = $this->paginate();
		foreach ($news as $k => $v) {
			$news[$k]['News'] = $this->_restore_html_news($v['News']);

		}

		$this->set('news', $news);

		$this->set('title_for_layout', " - ". __('News List', true));
	}

}
