<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Component
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * 一般メンバー認証コンポーネント
 */

/**
 * The parent component
 */
App::import('Component', 'Auth');

class MemberAuthComponent extends AuthComponent {

/**
 * The name of the model that represents users which will be authenticated.  Defaults to 'User'.
 *
 * @var string
 * @access public
 */
	var $userModel = 'Member';

	var $isAdmin = false;

	function initialize(&$controller)
	{
		parent::initialize($controller);

		// 管理画面と一般ユーザ識別
		if (isset($controller->params["prefix"]) && $controller->params["prefix"] == Configure::read('Routing.base_prefixes')) {
			$this->isAdmin = true;
		}

		// 管理画面はUsers、一般ユーザはMembersで認証
		if ($this->isAdmin === true) {
			$this->userModel = 'User';
			$this->loginAction = Router::normalize(array('controller' => 'users', 'action' => 'login'));

		} else {
			Configure::write('Session.cookie', 'CAKEPHPMEMBERSAUTH');

			// ログイン後リダイレクト設定
			$this->loginRedirect = $controller->params["url"]["url"];
			if ("/".$this->loginRedirect == Router::normalize(Configure::read('Routing.loginPath'))) {
				$this->loginRedirect = Router::normalize(Configure::read('Routing.basePath'));
			}
		}
	}


}


