<?php
/**
 * PHP version 5
 *
 * @category Config
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
/**
 * 動作環境設定(基本、編集不可）
 */

/*
 * パスの設定
 */
// ベースパス
Configure::write('Routing.basePath', array('controller' => 'users', 'action' => 'index'));

$prefixs = Configure::read('Routing.prefixes');
Configure::write('Routing.base_prefixes', $prefixs[0]);
Configure::write('Routing.adminBasePath', array('controller' => 'systems', 'action' => 'index', Configure::read('Routing.base_prefixes') => true, 'plugin' => null));

// ログインパス
Configure::write('Routing.loginPath', array('controller' => 'users', 'action' => 'login'));


/*
 * ACL:group_idの設定
 */
Configure::write('Group.admin', 1);
Configure::write('Group.subadmin', 2);
Configure::write('Group.watcher', 3);
Configure::write('Group.member', 4);
Configure::write('Group.locked', 5);
Configure::write('Group.deleted', 6);

/* TimeZone */
date_default_timezone_set('Asia/Tokyo');

/* メール送信設定 */
Configure::write('Qdmailer', array(
	'is_qmail' => false,
	'smtp' => false,
	'smtpLoglevelLink' => true,
	'errorDisplay' => false,
	'logLevel' => 0,
	'logFilename' => 'qdmailer.log',
	'errorlogLevel' => 2,
	'errorlogFilename' => 'qdmailer_error.log',
));

/* Benchmarkコンポーネント使用 */
define('BENCHMARK_MODE', false);

/* デモモード */
// guest UserIDでの操作制限
Configure::write('Mode.Demo', false);

/* php.ini設定の上書き */
// mb_string関連
mb_language('Japanese');
ini_set('mbstring.detect_order', 'eucJP-win,UTF-8,SJIS-win,jis');
ini_set('mbstring.language','UTF-8');
ini_set('mbstring.encoding_translation','On');
ini_set('mbstring.output_buffering','On');
ini_set('mbstring.output_hanler','mb_output_handler');
ini_set('mbstring.http_input'  , 'auto');
ini_set('mbstring.http_output' , 'pass');
//ini_set('mbstring.http_input'  , 'UTF-8');
//ini_set('mbstring.http_output' , 'UTF-8');
ini_set('mbstring.internal_encoding', 'UTF-8');
ini_set('mbstring.script_encoding'  , 'UTF-8');
ini_set('mbstring.substitute_character', 'none');
mb_regex_encoding('UTF-8');
// 携帯絵文字関連
mb_substitute_character(0x3013);
mb_substitute_character('long');

Configure::write('Version', 'beta');
