# Include hook code here
require "active_record"
require "force_columns"
ActiveRecord::ConnectionAdapters::AbstractAdapter.__send__(:include, ForceColumns)
ActiveRecord::Base.__send__(:include, ForceColumns::ForceDomain)
# NOTE monkey patch. Check this code when update Rails.
class ActiveRecord::Base
  class << self
    def inherited_with_force_domain(subclass)
      inherited_without_force_domain(subclass)
      changed
      notify_observers :observed_class_inherited, subclass
      subclass.__send__ :force_domain
    end
    alias_method_chain :inherited, :force_domain
  end
end
