/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class DataTypeUtils {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());
    public static final int MAX_STRING_PROPERTY_LENGTH = 500;
    public static final int MAX_SHORT_BLOB_PROPERTY_LENGTH = 500;
    public static final int MAX_LINK_PROPERTY_LENGTH = 2038;
    private static final Set<Class<?>> supportedTypes = new HashSet();

    public static void checkSupportedValue(Object value) {
        DataTypeUtils.checkSupportedValue(null, value);
    }

    public static void checkSupportedValue(String name, Object value) {
        DataTypeUtils.checkSupportedValue(name, value, true, false);
    }

    static void checkSupportedValue(String name, Object value, boolean allowMultiValue, boolean requireMultiValue) {
        if (value instanceof Collection) {
            if (!allowMultiValue) {
                throw new IllegalArgumentException("A collection of values is not allowed.");
            }
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                for (Object obj : values) {
                    DataTypeUtils.checkSupportedSingleValue(name, obj);
                }
            } else if (requireMultiValue) {
                throw new IllegalArgumentException("A collection with at least one value is required.");
            }
        } else {
            if (requireMultiValue) {
                throw new IllegalArgumentException("A collection of values is required.");
            }
            DataTypeUtils.checkSupportedSingleValue(name, value);
        }
    }

    private static void checkSupportedSingleValue(String name, Object value) {
        int length;
        if (value == null) {
            return;
        }
        if ("__key__".equals(name) && !(value instanceof Key)) {
            logger.warning("__key__ value should be of type Key");
        }
        String prefix = name == null ? "" : name + ": ";
        if (!DataTypeUtils.isSupportedType(value.getClass())) {
            throw new IllegalArgumentException(prefix + value.getClass().getName() + " is not a supported property type.");
        }
        if (value instanceof String) {
            int length2 = ((String)value).length();
            if (length2 > 500) {
                throw new IllegalArgumentException(prefix + "String properties must be " + 500 + " characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof Link) {
            int length3 = ((Link)value).getValue().length();
            if (length3 > 2038) {
                throw new IllegalArgumentException(prefix + "Link properties must be " + 2038 + " characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof ShortBlob && (length = ((ShortBlob)value).getBytes().length) > 500) {
            throw new IllegalArgumentException(prefix + "byte[] properties must be " + 500 + " bytes or less.  Instead, use " + Blob.class.getName() + ", which can store binary " + "data of any size.");
        }
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return supportedTypes.contains(clazz);
    }

    public static Set<Class<?>> getSupportedTypes() {
        return Collections.unmodifiableSet(supportedTypes);
    }

    private DataTypeUtils() {
    }

    static {
        supportedTypes.add(Boolean.class);
        supportedTypes.add(String.class);
        supportedTypes.add(Byte.class);
        supportedTypes.add(Short.class);
        supportedTypes.add(Integer.class);
        supportedTypes.add(Long.class);
        supportedTypes.add(Float.class);
        supportedTypes.add(Double.class);
        supportedTypes.add(User.class);
        supportedTypes.add(Key.class);
        supportedTypes.add(Blob.class);
        supportedTypes.add(Text.class);
        supportedTypes.add(Date.class);
        supportedTypes.add(Link.class);
        supportedTypes.add(ShortBlob.class);
        supportedTypes.add(GeoPt.class);
        supportedTypes.add(Category.class);
        supportedTypes.add(Rating.class);
        supportedTypes.add(PhoneNumber.class);
        supportedTypes.add(PostalAddress.class);
        supportedTypes.add(Email.class);
        supportedTypes.add(IMHandle.class);
        supportedTypes.add(BlobKey.class);
    }
}

