/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.appengine.tools.admin.AppYamlTranslator;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.util.FileIterator;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.MimeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppVersionUpload {
    private static final int MAX_FILE_COUNT = 3000;
    private static final long MB = 1000000L;
    private static final long MAX_FILE_SIZE = 10000000L;
    private static final long MAX_RESOURCE_TOTALSIZE = 150000000L;
    private static final int MAX_FILES_PER_PRECOMPILE = 50;
    private static final MimeTypes mimeTypes = new MimeTypes();
    protected ServerConnection connection;
    protected Application app;
    protected final String majorVersionId;
    protected final String backend;
    private Logger logger = Logger.getLogger(AppVersionUpload.class.getName());
    private boolean inTransaction = false;
    private Map<String, FileInfo> files = new HashMap<String, FileInfo>();
    private boolean deployed = false;
    private static final int MAX_FILES_TO_CLONE = 100;
    private static final String LIST_DELIMITER = "\n";
    private static final String TUPLE_DELIMITER = "|";

    public AppVersionUpload(ServerConnection connection, Application app) {
        this(connection, app, null, null);
    }

    public AppVersionUpload(ServerConnection connection, Application app, String backend, String majorVersionId) {
        this.connection = connection;
        this.app = app;
        this.backend = backend;
        this.majorVersionId = majorVersionId != null ? majorVersionId : app.getAppEngineWebXml().getMajorVersionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpload() throws IOException {
        try {
            File basepath = this.getBasepath();
            this.app.statusUpdate("Scanning files on local disk.", 20);
            int numFiles = 0;
            long resourceTotal = 0L;
            for (File f : new FileIterator(basepath)) {
                this.logger.fine("Processing file '" + f + "'.");
                if (f.length() > 10000000L) {
                    throw new IOException("File " + f.getPath() + " is too large (limit " + 10000000L + " bytes).");
                }
                resourceTotal += this.addFile(f, basepath);
                if (++numFiles % 250 != 0) continue;
                this.app.statusUpdate("Scanned " + numFiles + " files.");
            }
            if (numFiles > 3000) {
                throw new IOException("Applications are limited to 3000 files, you have " + numFiles + ".");
            }
            if (resourceTotal > 150000000L) {
                throw new IOException("Applications are limited to 150000000 bytes of resource files, you have " + resourceTotal + ".");
            }
            Collection<FileInfo> missingFiles = this.beginTransaction();
            this.app.statusUpdate("Uploading " + missingFiles.size() + " files.", 50);
            if (missingFiles.size() > 0) {
                numFiles = 0;
                int quarter = Math.max(1, missingFiles.size() / 4);
                for (FileInfo missingFile : missingFiles) {
                    this.logger.fine("Uploading file '" + missingFile + "'");
                    this.uploadFile(missingFile);
                    if (++numFiles % quarter != 0) continue;
                    this.app.statusUpdate("Uploaded " + numFiles + " files.");
                }
            }
            this.uploadErrorHandlers(this.app.getAppEngineWebXml(), basepath);
            if (this.app.getAppEngineWebXml().getPrecompilationEnabled()) {
                this.precompile();
            }
            this.commit();
        }
        finally {
            this.rollback();
        }
        this.updateIndexes();
        this.updateCron();
        this.updateQueue();
        this.updateDos();
    }

    private void uploadErrorHandlers(AppEngineWebXml appEngineWebXml, File basepath) throws IOException {
        List<AppEngineWebXml.ErrorHandler> errorHandlers = appEngineWebXml.getErrorHandlers();
        if (!errorHandlers.isEmpty()) {
            this.app.statusUpdate("Uploading " + errorHandlers.size() + " file(s) " + "for static error handlers.");
            for (AppEngineWebXml.ErrorHandler handler : errorHandlers) {
                File file = new File(basepath, "__static__/" + handler.getFile());
                FileInfo info = new FileInfo(file, basepath);
                String error = info.checkValidFilename();
                if (error != null) {
                    throw new IOException("Could not find static error handler: " + error);
                }
                info.mimeType = this.getMimeType(info.path);
                String errorType = handler.getErrorCode();
                if (errorType == null) {
                    errorType = "default";
                }
                this.send("/api/appversion/adderrorblob", info.file, info.mimeType, "path", errorType);
            }
        }
    }

    public void precompile() throws IOException {
        this.app.statusUpdate("Initializing precompilation...");
        ArrayList<String> filesToCompile = new ArrayList<String>();
        int errorCount = 0;
        while (true) {
            try {
                filesToCompile.addAll(this.sendPrecompileRequest(Collections.<String>emptyList()));
            }
            catch (IOException ex) {
                if (errorCount < 3) {
                    ++errorCount;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex2) {
                        IOException ex3 = new IOException("Interrupted during precompilation.");
                        ex3.initCause(ex2);
                        throw ex3;
                    }
                    continue;
                }
                IOException ex2 = new IOException("Precompilation failed.  Consider adding <precompilation-enabled>false</precompilation-enabled> to your appengine-web.xml and trying again.");
                ex2.initCause(ex);
                throw ex2;
            }
            break;
        }
        errorCount = 0;
        IOException lastError = null;
        while (!filesToCompile.isEmpty()) {
            try {
                if (this.precompileChunk(filesToCompile)) {
                    errorCount = 0;
                }
            }
            catch (IOException ex) {
                lastError = ex;
                ++errorCount;
                Collections.shuffle(filesToCompile);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex2) {
                    IOException ex3 = new IOException("Interrupted during precompilation.");
                    ex3.initCause(ex2);
                    throw ex3;
                }
            }
            if (errorCount <= 3) continue;
            IOException ex2 = new IOException("Precompilation failed with " + filesToCompile.size() + " file(s) remaining.  " + "Consider adding" + " <precompilation-enabled>false</precompilation-enabled>" + " to your " + "appengine-web.xml and trying again.");
            ex2.initCause(lastError);
            throw ex2;
        }
    }

    private boolean precompileChunk(List<String> filesToCompile) throws IOException {
        int filesLeft = filesToCompile.size();
        if (filesLeft == 0) {
            this.app.statusUpdate("Initializing precompilation...");
        } else {
            this.app.statusUpdate(MessageFormat.format("Precompiling... {0} file(s) left.", filesLeft));
        }
        List<String> subset = filesToCompile.subList(0, Math.min(filesLeft, 50));
        List<String> remainingFiles = this.sendPrecompileRequest(subset);
        subset.clear();
        filesToCompile.addAll(remainingFiles);
        return filesToCompile.size() < filesLeft;
    }

    private List<String> sendPrecompileRequest(List<String> filesToCompile) throws IOException {
        String response = this.send("/api/appversion/precompile", Join.join(LIST_DELIMITER, filesToCompile), new String[0]);
        if (response.length() > 0) {
            return Arrays.asList(response.split(LIST_DELIMITER));
        }
        return Collections.emptyList();
    }

    public void updateIndexes() throws IOException {
        if (this.app.getIndexesXml() != null) {
            this.app.statusUpdate("Uploading index definitions.");
            this.send("/api/datastore/index/add", this.getIndexYaml(), new String[0]);
        }
    }

    public void updateCron() throws IOException {
        String yaml = this.getCronYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading cron jobs.");
            this.send("/api/datastore/cron/update", yaml, new String[0]);
        }
    }

    public void updateQueue() throws IOException {
        String yaml = this.getQueueYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading task queues.");
            this.send("/api/queue/update", yaml, new String[0]);
        }
    }

    public void updateDos() throws IOException {
        String yaml = this.getDosYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading DoS entries.");
            this.send("/api/dos/update", yaml, new String[0]);
        }
    }

    protected String getIndexYaml() {
        return this.app.getIndexesXml().toYaml();
    }

    protected String getCronYaml() {
        if (this.app.getCronXml() != null) {
            return this.app.getCronXml().toYaml();
        }
        return null;
    }

    protected String getQueueYaml() {
        if (this.app.getQueueXml() != null) {
            return this.app.getQueueXml().toYaml();
        }
        return null;
    }

    protected String getDosYaml() {
        if (this.app.getDosXml() != null) {
            return this.app.getDosXml().toYaml();
        }
        return null;
    }

    protected String getAppYaml() {
        HashSet<String> staticFiles = new HashSet<String>();
        for (FileInfo info : this.files.values()) {
            if (!this.isStatic(info)) continue;
            staticFiles.add(info.path);
        }
        AppYamlTranslator translator = new AppYamlTranslator(this.app.getAppEngineWebXml(), this.app.getWebXml(), this.app.getBackendsXml(), this.app.getApiVersion(), staticFiles);
        String yaml = translator.getYaml();
        this.logger.fine("Generated app.yaml file:\n" + yaml);
        return yaml;
    }

    private File getBasepath() {
        File path = this.app.getStagingDir();
        if (path == null) {
            path = new File(this.app.getPath());
        }
        return path;
    }

    private long addFile(File file, File base) throws IOException {
        long returnBytes = file.length();
        if (this.inTransaction) {
            throw new IllegalStateException("Already in a transaction.");
        }
        FileInfo info = new FileInfo(file, base);
        String error = info.checkValidFilename();
        if (error != null) {
            this.logger.severe(error);
            return 0L;
        }
        if (this.isStatic(info)) {
            info.mimeType = this.getMimeType(info.path);
            returnBytes = 0L;
        }
        this.files.put(info.path, info);
        return returnBytes;
    }

    private Collection<FileInfo> beginTransaction() throws IOException {
        if (this.inTransaction) {
            throw new IllegalStateException("Already in a transaction.");
        }
        if (this.backend == null) {
            this.app.statusUpdate("Initiating update.");
        } else {
            this.app.statusUpdate("Initiating update of backend " + this.backend + ".");
        }
        this.send("/api/appversion/create", this.getAppYaml(), new String[0]);
        this.inTransaction = true;
        ArrayList<FileInfo> blobsToClone = new ArrayList<FileInfo>(this.files.size());
        ArrayList<FileInfo> filesToClone = new ArrayList<FileInfo>(this.files.size());
        for (FileInfo f : this.files.values()) {
            if (f.mimeType == null) {
                filesToClone.add(f);
                continue;
            }
            blobsToClone.add(f);
        }
        TreeMap<String, FileInfo> filesToUpload = new TreeMap<String, FileInfo>();
        this.cloneFiles("/api/appversion/cloneblobs", blobsToClone, "static", filesToUpload);
        this.cloneFiles("/api/appversion/clonefiles", filesToClone, "application", filesToUpload);
        this.logger.fine("Files to upload :");
        for (FileInfo f : filesToUpload.values()) {
            this.logger.fine("\t" + f);
        }
        this.files = filesToUpload;
        return new ArrayList<FileInfo>(filesToUpload.values());
    }

    private void cloneFiles(String url, Collection<FileInfo> filesParam, String type, Map<String, FileInfo> filesToUpload) throws IOException {
        if (filesParam.isEmpty()) {
            return;
        }
        this.app.statusUpdate("Cloning " + filesParam.size() + " " + type + " files.");
        int cloned = 0;
        int remaining = filesParam.size();
        ArrayList<FileInfo> chunk = new ArrayList<FileInfo>(100);
        for (FileInfo file : filesParam) {
            String result;
            chunk.add(file);
            if (--remaining != 0 && chunk.size() < 100) continue;
            if (cloned > 0) {
                this.app.statusUpdate("Cloned " + cloned + " files.");
            }
            if ((result = this.send(url, AppVersionUpload.buildClonePayload(chunk), new String[0])) != null && result.length() > 0) {
                for (String path : result.split(LIST_DELIMITER)) {
                    if (path == null || path.length() == 0) continue;
                    FileInfo info = this.files.get(path);
                    if (info == null) {
                        this.logger.warning("Skipping " + path + ": missing FileInfo");
                        continue;
                    }
                    filesToUpload.put(path, info);
                }
            }
            cloned += chunk.size();
            chunk.clear();
        }
    }

    private void uploadFile(FileInfo file) throws IOException {
        if (!this.inTransaction) {
            throw new IllegalStateException("beginTransaction() must be called before uploadFile().");
        }
        if (!this.files.containsKey(file.path)) {
            throw new IllegalArgumentException("File " + file.path + " is not in the list of files to be uploaded.");
        }
        this.files.remove(file.path);
        if (file.mimeType == null) {
            this.send("/api/appversion/addfile", file.file, null, "path", file.path);
        } else {
            this.send("/api/appversion/addblob", file.file, file.mimeType, "path", file.path);
        }
    }

    private void commit() throws IOException {
        this.deploy();
        try {
            boolean ready = this.retryWithBackoff(1.0, 2.0, 60.0, 20, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AppVersionUpload.this.isReady();
                }
            });
            if (!ready) {
                this.logger.severe("Version still not ready to serve, aborting.");
                throw new RuntimeException("Version not ready.");
            }
            this.startServing();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deploy() throws IOException {
        if (!this.inTransaction) {
            throw new IllegalStateException("beginTransaction() must be called before uploadFile().");
        }
        if (this.files.size() > 0) {
            throw new IllegalStateException("Some required files have not been uploaded.");
        }
        this.app.statusUpdate("Deploying new version.", 20);
        this.send("/api/appversion/deploy", "", new String[0]);
        this.deployed = true;
    }

    private boolean isReady() throws IOException {
        if (!this.deployed) {
            throw new IllegalStateException("deploy() must be called before isReady()");
        }
        String result = this.send("/api/appversion/isready", "", new String[0]);
        return "1".equals(result.trim());
    }

    private void startServing() throws IOException {
        if (!this.deployed) {
            throw new IllegalStateException("deploy() must be called before startServing()");
        }
        this.app.statusUpdate("Closing update: new version is ready to start serving.");
        this.send("/api/appversion/startserving", "", new String[0]);
        this.inTransaction = false;
    }

    public void forceRollback() throws IOException {
        this.app.statusUpdate("Rolling back the update" + this.backend == null ? "." : " on backend " + this.backend + ".");
        this.send("/api/appversion/rollback", "", new String[0]);
    }

    private void rollback() throws IOException {
        if (!this.inTransaction) {
            return;
        }
        this.forceRollback();
    }

    private String send(String url, String payload, String ... args) throws IOException {
        return this.connection.post(url, payload, this.addVersionToArgs(args));
    }

    private String send(String url, File payload, String mimeType, String ... args) throws IOException {
        return this.connection.post(url, payload, mimeType, this.addVersionToArgs(args));
    }

    private String[] addVersionToArgs(String ... args) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(args));
        result.add("app_id");
        result.add(this.app.getAppId());
        if (this.backend != null) {
            result.add("backend");
            result.add(this.backend);
        } else if (this.majorVersionId != null) {
            result.add("version");
            result.add(this.majorVersionId);
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean retryWithBackoff(double initialDelay, double backoffFactor, double maxDelay, int maxTries, Callable<Boolean> callable) throws Exception {
        long delayMillis = (long)(initialDelay * 1000.0);
        long maxDelayMillis = (long)(maxDelay * 1000.0);
        if (callable.call().booleanValue()) {
            return true;
        }
        while (maxTries > 1) {
            this.app.statusUpdate("Will check again in " + delayMillis / 1000L + " seconds.");
            Thread.sleep(delayMillis);
            delayMillis = (long)((double)delayMillis * backoffFactor);
            if (delayMillis > maxDelayMillis) {
                delayMillis = maxDelayMillis;
            }
            --maxTries;
            if (!callable.call().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isStatic(FileInfo info) {
        return info.path.contains("__static__/");
    }

    private static String buildClonePayload(Collection<FileInfo> files) {
        StringBuffer data = new StringBuffer();
        boolean first = true;
        for (FileInfo file : files) {
            if (first) {
                first = false;
            } else {
                data.append(LIST_DELIMITER);
            }
            data.append(file.path);
            data.append(TUPLE_DELIMITER);
            data.append(file.hash);
            if (file.mimeType == null) continue;
            data.append(TUPLE_DELIMITER);
            data.append(file.mimeType);
        }
        return data.toString();
    }

    private String getMimeType(String path) {
        String mimeType = this.app.getWebXml().getMimeTypeForPath(path);
        if (mimeType != null) {
            return mimeType;
        }
        Buffer buffer = mimeTypes.getMimeByExtension(path);
        if (buffer != null) {
            return new String(buffer.asArray());
        }
        return "application/octet-stream";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfo
    implements Comparable<FileInfo> {
        public File file;
        public String path;
        public String hash;
        public String mimeType;
        private static final Pattern FILE_PATH_POSITIVE_RE = Pattern.compile("^[ 0-9a-zA-Z._+/$-]{1,256}$");
        private static final Pattern FILE_PATH_NEGATIVE_RE_1 = Pattern.compile("[.][.]|^[.]/|[.]$|/[.]/|^-");
        private static final Pattern FILE_PATH_NEGATIVE_RE_2 = Pattern.compile("//|/$");
        private static final Pattern FILE_PATH_NEGATIVE_RE_3 = Pattern.compile("^ | $|/ | /");
        private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        public FileInfo(File f, File base) throws IOException {
            this.file = f;
            this.path = FileInfo.calculatePath(f, base);
            this.hash = this.calculateHash();
        }

        public String toString() {
            return (this.mimeType == null ? "" : this.mimeType) + '\t' + this.hash + "\t" + this.path;
        }

        @Override
        public int compareTo(FileInfo other) {
            return this.path.compareTo(other.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileInfo) {
                return this.path.equals(((FileInfo)obj).path);
            }
            return false;
        }

        private String checkValidFilename() {
            if (!FILE_PATH_POSITIVE_RE.matcher(this.path).matches()) {
                return "Invalid character in filename: " + this.path;
            }
            if (FILE_PATH_NEGATIVE_RE_1.matcher(this.path).find()) {
                return "Filname cannot contain '.' or '..' or start with '-': " + this.path;
            }
            if (FILE_PATH_NEGATIVE_RE_2.matcher(this.path).find()) {
                return "Filname cannot have trailing / or contain //: " + this.path;
            }
            if (FILE_PATH_NEGATIVE_RE_3.matcher(this.path).find()) {
                return "Any spaces must be in the middle of a filename: '" + this.path + "'";
            }
            return null;
        }

        public String calculateHash() throws IOException {
            FileInputStream s = new FileInputStream(this.file);
            byte[] buf = new byte[4096];
            try {
                int numRead;
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                while ((numRead = ((InputStream)s).read(buf)) != -1) {
                    digest.update(buf, 0, numRead);
                }
                StringBuffer hashValue = new StringBuffer(40);
                int i = 0;
                for (byte b : digest.digest()) {
                    if (i > 0 && i % 4 == 0) {
                        hashValue.append('_');
                    }
                    hashValue.append(HEX[b >> 4 & 0xF]);
                    hashValue.append(HEX[b & 0xF]);
                    ++i;
                }
                String string = hashValue.toString();
                return string;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    ((InputStream)s).close();
                }
                catch (IOException ex) {}
            }
        }

        private static String calculatePath(File f, File base) {
            int offset = base.getPath().length();
            String path = f.getPath().substring(offset);
            if (File.separatorChar == '\\') {
                path = path.replace('\\', '/');
            }
            offset = 0;
            while (path.charAt(offset) == '/') {
                ++offset;
            }
            if (offset > 0) {
                path = path.substring(offset);
            }
            return path;
        }
    }
}

