/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Escaper;
import com.google.appengine.repackaged.com.google.common.base.PercentEscaper;

@GoogleInternal
@GwtCompatible
public final class UriEscapers {
    public static final String URI_SAFECHARS_JAVA = "-_.*";
    private static final Escaper URI_ESCAPER = new PercentEscaper("-_.*", true);
    private static final Escaper URI_ESCAPER_NO_PLUS = new PercentEscaper("-_.*", false);
    public static final String URI_SAFECHARS_PATH = "-._~!$'()*,;&=@:";
    private static final Escaper URI_PATH_ESCAPER = new PercentEscaper("-._~!$'()*,;&=@:", false);
    public static final String URI_SAFECHARS_QUERY_STRING = "-._~!$'()*,;@:/?";
    private static final Escaper QUERY_STRING_ESCAPER = new PercentEscaper("-._~!$'()*,;@:/?", true);
    private static final Escaper QUERY_STRING_ESCAPER_NO_PLUS = new PercentEscaper("-._~!$'()*,;@:/?", false);
    private static final Escaper CPP_URI_ESCAPER = new PercentEscaper("!()*-._~,/:", true);

    private UriEscapers() {
    }

    public static Escaper uriEscaper() {
        return UriEscapers.uriEscaper(true);
    }

    public static Escaper uriEscaper(boolean plusForSpace) {
        return plusForSpace ? URI_ESCAPER : URI_ESCAPER_NO_PLUS;
    }

    public static Escaper uriPathEscaper() {
        return URI_PATH_ESCAPER;
    }

    public static Escaper uriQueryStringEscaper(boolean plusForSpace) {
        return plusForSpace ? QUERY_STRING_ESCAPER : QUERY_STRING_ESCAPER_NO_PLUS;
    }

    public static Escaper cppUriEscaper() {
        return CPP_URI_ESCAPER;
    }
}

