/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream stream;
            if (this.part instanceof MimeMessage) {
                stream = ((MimeMessage)this.part).getContentStream();
            } else if (this.part instanceof MimeBodyPart) {
                stream = ((MimeBodyPart)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            return this.checkPartEncoding(this.part, stream);
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private InputStream checkPartEncoding(MimePart part, InputStream stream) throws MessagingException {
        String encoding = part.getEncoding();
        if (encoding == null) {
            return stream;
        }
        if ((encoding = encoding.toLowerCase()).equals("7bit") || encoding.equals("8bit") || encoding.equals("binary")) {
            return stream;
        }
        String contentType = part.getContentType();
        if (contentType != null) {
            try {
                ContentType type = new ContentType(contentType);
                if (type.match("multipart/*")) {
                    return stream;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return MimeUtility.decode(stream, encoding);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this.part);
    }
}

