/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldIdentity;

public class IntIdentity
extends SingleFieldIdentity {
    private int key;

    public IntIdentity(Class pcClass, int key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntIdentity(Class pcClass, Integer key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntIdentity(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Integer.parseInt(str);
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntIdentity() {
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        return Integer.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        IntIdentity other = (IntIdentity)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof IntIdentity) {
            IntIdentity other = (IntIdentity)o;
            return this.key - other.key;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return new Integer(this.key);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readInt();
    }
}

