/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerClassLoader;
import com.google.appengine.tools.development.agent.AppEngineDevAgent;
import com.google.apphosting.utils.security.SecurityManagerInstaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.Permission;
import java.util.PropertyPermission;

public class DevAppServerFactory {
    static final String DEV_APP_SERVER_CLASS = "com.google.appengine.tools.development.DevAppServerImpl";

    public DevAppServer createDevAppServer(File appLocation, String address, int port) {
        return this.createDevAppServer(new Class[]{File.class, String.class, Integer.TYPE}, new Object[]{appLocation, address, port});
    }

    private DevAppServer createDevAppServer(File appLocation, String appEngineWebXml, String address, int port, boolean useCustomStreamHandler) {
        return this.createDevAppServer(new Class[]{File.class, String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE}, new Object[]{appLocation, null, appEngineWebXml, address, port, useCustomStreamHandler});
    }

    private DevAppServer createDevAppServer(Class[] ctorArgTypes, Object[] ctorArgs) {
        DevAppServer devAppServer;
        SecurityManagerInstaller.install(new URL[0]);
        DevAppServerClassLoader loader = DevAppServerClassLoader.newClassLoader(DevAppServerFactory.class.getClassLoader());
        this.testAgentIsInstalled();
        try {
            Class<?> devAppServerClass = Class.forName(DEV_APP_SERVER_CLASS, true, loader);
            Constructor<?> cons = devAppServerClass.getConstructor(ctorArgTypes);
            cons.setAccessible(true);
            devAppServer = (DevAppServer)cons.newInstance(ctorArgs);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
        System.setSecurityManager(new CustomSecurityManager(devAppServer));
        return devAppServer;
    }

    private void testAgentIsInstalled() {
        try {
            AppEngineDevAgent.getAgent();
        }
        catch (Throwable t) {
            String msg = "Unable to locate the App Engine agent. Please use dev_appserver, KickStart,  or set the jvm flag: \"-javaagent:<sdk_root>/lib/agent/appengine-agent.jar\"";
            throw new RuntimeException(msg, t);
        }
    }

    private static class CustomSecurityManager
    extends SecurityManager {
        private static final RuntimePermission PERMISSION_MODIFY_THREAD_GROUP = new RuntimePermission("modifyThreadGroup");
        private static final RuntimePermission PERMISSION_MODIFY_THREAD = new RuntimePermission("modifyThread");
        private static final String KEYCHAIN_JNILIB = "/libkeychain.jnilib";
        private static final Object PERMISSION_LOCK = new Object();
        private final DevAppServer devAppServer;

        public CustomSecurityManager(DevAppServer devAppServer) {
            this.devAppServer = devAppServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean appHasPermission(Permission perm) {
            Object object = PERMISSION_LOCK;
            synchronized (object) {
                AppContext context = this.devAppServer.getAppContext();
                if (context.getUserPermissions().implies(perm) || context.getApplicationPermissions().implies(perm)) {
                    return true;
                }
            }
            return "read".equals(perm.getActions()) && perm.getName().endsWith(KEYCHAIN_JNILIB);
        }

        public void checkPermission(Permission perm) {
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm);
            }
        }

        public void checkPermission(Permission perm, Object context) {
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm, context);
            }
        }

        public void checkAccess(ThreadGroup g) {
            if (g == null) {
                throw new NullPointerException("thread group can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD_GROUP);
        }

        public void checkAccess(Thread t) {
            if (t == null) {
                throw new NullPointerException("thread can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD);
        }

        public boolean isDevAppServerThread() {
            return Boolean.getBoolean("devappserver-thread-" + Thread.currentThread().getName());
        }
    }
}

