package com.td.webapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import android.database.sqlite.SQLiteDatabase;

import com.td.TrainEditActivity;
import com.td.db.DatabaseHelper;
import com.td.db.Prefecture;
import com.td.db.PrefectureDao;
import com.td.db.Relation;
import com.td.db.RelationDao;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.utility.Debug;
import com.td.utility.ExceptionUtil;
import com.td.utility.TdException;

public class RouteUpdater {
	private static final String URL1 = "http://express.heartrails.com/api/xml?method=getPrefectures";
	private static final String URL2 = "http://express.heartrails.com/api/xml?method=getLines&prefecture=";
	private static final String NAME1 = "prefecture";
	private static final String NAME2 = "line";

	public boolean update() {
		SQLiteDatabase db = null;
		boolean isStartTransaction = false;
		boolean status = false;
		
		try {
			PrefectureDao preDao = PrefectureDao.getInstance();
			TrainDao trainDao = TrainDao.getInstance();
			RelationDao relDao = RelationDao.getInstance();
			List<String> list1 = getList(URL1, NAME1);
			List<String> list2 = null;
			if (list1 == null) {
				return status;
			}

			DatabaseHelper helper = DatabaseHelper.getInstance();
			db = helper.getWritableDatabase();

			db.beginTransaction();
			isStartTransaction = true;
			preDao.deleteNT();
			trainDao.deleteNT();
			relDao.deleteNT();
			db.setTransactionSuccessful();		
			db.endTransaction();
			isStartTransaction = false;

			Prefecture pre = new Prefecture();
			Train train = new Train();
			Relation rel = new Relation();

			List<Train> ret;

			for (String key : list1) {
				// gUNVJn
				db.beginTransaction();
				isStartTransaction = true;
				
				pre.setName(key);
				long pid = preDao.addNT(pre);
				if (pid < 0) {
					throw new TdException();
				}

				String param = encode(key);
				if (param == null) {
					throw new TdException();
				}
				String url = URL2 + param;
				list2 = getList(url, NAME2);
				if (list2 == null) {
					throw new TdException();
				}
				for (String name : list2) {
					long tid;
					
					ret = trainDao.search(name);
					if (ret.size() > 0) {
						// o^ς
						tid = ret.get(0).getId();
					}
					else {
						// VKo^Bids
						train.setName(name);
						String sname = filter(name);
						train.setSname(sname);
						
						tid = trainDao.addNT(train);
						if (tid < 0) {
							throw new TdException();
						}
					}
					rel.setPid(pid);
					rel.setTid(tid);
					long id = relDao.addNT(rel);
					if (id < 0) {
						throw new TdException();
					}
					
					ExceptionUtil.getInstance().throwException(
							ExceptionUtil.TAG_E10);
				}
				// gUNVI
				db.setTransactionSuccessful();		
				db.endTransaction();
				isStartTransaction = false;
				
				// ߂{^Ōł܂Ȃ悤ɂ邽
				Thread.yield();
			}
			status = true;
		}
		catch (Exception e){
			Debug.d(this, null, e);
			status = false;
		} 
		finally {
			if (db != null) {
				if (isStartTransaction){
					db.endTransaction();
					isStartTransaction = false;
				}
			}
		}
		return status;
	}

	public static String filter(String name) {
		int len = name.length();
		
		String ch;
		if (len > 1){
			ch = name.substring(len - 1, len);
			if (ch.equals(TrainEditActivity.LINE)){
				name = name.substring(0, len - 1);
				len--;
			}
		}
		if (len > 2){
			ch = name.substring(0, 2);
			if (ch.equals(TrainEditActivity.JR)){
				name = name.substring(2, len);
			}
		}
		return name;
	}

	private String encode(String s) {
		try {
			return URLEncoder.encode(s, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}

	private List<String> getList(String url, String name) {
		HttpClient client = new HttpClient();
		OutputStream os = new ByteArrayOutputStream();
		int status;
		List<String> list = null;

		try {
			status = client.get(url, os);
			if (status == HttpStatus.SC_OK) {
				list = parse(os, name);
			}
		} catch (ClientProtocolException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
		return list;
	}

	private List<String> parse(OutputStream os, String name) {
		List<String> list = new ArrayList<String>();

		try {
			final XmlPullParserFactory factory = XmlPullParserFactory
					.newInstance();
			final XmlPullParser parser = factory.newPullParser();
			// XMLp[Tɉ͂eݒ肷
			parser.setInput(new StringReader(os.toString()));

			// XML͂̏I܂Ń[vĉ͂
			for (int eventType = parser.getEventType(); eventType != XmlPullParser.END_DOCUMENT; eventType = parser
					.next()) {
				String tagName;
				String tagText;

				switch (eventType) {
				// TAG̎n܂
				case XmlPullParser.START_TAG:
					// TAG̖O擾
					tagName = parser.getName();

					if (tagName.equals(name)) {
						// ̗vf֐i
						parser.next();

						// vfTEXTeo
						if (parser.getEventType() == XmlPullParser.TEXT) {
							tagText = parser.getText();
							list.add(tagText);
						}
					}
					break;
				}
			}
			return list;
		} catch (XmlPullParserException e1) {
			return null;
		} catch (IOException e2) {
			return null;
		}
	}
}
