package com.td.utility;

import android.content.Context;

import com.td.WaitActivity;
import com.td.service.TrainDelayedServiceImpl;
import com.td.service.TrainService;

public class StatusFlagFactory {
	public enum Type {
		TRAIN_SERVICE, TRAIN_DELAY_SERVICE, WAIT_ACTIVITY, DB_UPDATE
	};

	private static StatusFlagFactory instance = null;

	private StatusFlagFactory() {

	}

	public static StatusFlagFactory getInstance() {
		if (instance == null) {
			instance = new StatusFlagFactory();
		}
		return instance;
	}

	public void init(Context context) {
		Type[] vals = Type.values();
		for (int i = 0; i < vals.length; i++) {
			Type t = vals[i];
			StatusFlag sf = getStatusFlag(context, t);
			sf.setOff();
		}
	}

	public StatusFlag getStatusFlag(Context context, Type type) {
		StatusFlag tsSf = null;

		switch (type) {
		case TRAIN_SERVICE:
			tsSf = new StatusFlag(context, TrainService.class.getName(),
					StatusFlag.TERM_10M);
			break;
		case TRAIN_DELAY_SERVICE:
			tsSf = new StatusFlag(context,
					TrainDelayedServiceImpl.class.getName(),
					StatusFlag.TERM_NONE);
			break;
		case WAIT_ACTIVITY:
			tsSf = new StatusFlag(context, WaitActivity.class.getName(),
					StatusFlag.TERM_NONE);
		case DB_UPDATE:
			tsSf = new StatusFlag(context, TrainDelayedServiceImpl.class.getName() + "_DB",
					StatusFlag.TERM_NONE);
		}
		return tsSf;
	}
}
