package com.td.service;

import java.lang.ref.WeakReference;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;

import com.td.WaitActivity;
import com.td.broadcast.DelayReceiver;
import com.td.db.DatabaseHelper;
import com.td.db.PrefectureDao;
import com.td.utility.Debug;
import com.td.utility.StatusFlag;
import com.td.utility.StatusFlagFactory;
import com.td.utility.TdException;
import com.td.webapi.RouteUpdater;

public class TrainService extends Service {
	private WeakReference<ITrainServiceCallback> callbackRef;

	private ITrainService.Stub impl = new ITrainService.Stub() {
		public int doExecute(String branch) throws RemoteException {
			try {
				DatabaseHelper.init(getApplicationContext());
				Thread thread = new Thread() {
					public void run() {
						boolean status = false;
						StatusFlag tsSf = StatusFlagFactory.getInstance().getStatusFlag(
								TrainService.this, StatusFlagFactory.Type.TRAIN_SERVICE);
						try {
							Debug.t(TrainService.this, "TrainService start");

							RouteUpdater ru = new RouteUpdater();
							status = ru.update();
							ru = null;

							if (callbackRef != null) {
								ITrainServiceCallback callback = callbackRef
										.get();
								if (callback != null) {
									callbackRef.clear();
									callback.notify("msg",
											(status) ? WaitActivity.ID_OK
													: WaitActivity.ID_NG);
									callback = null;
								}
							}
							// ItOZbg
							if (status){
								tsSf.setOff();
							}
							else {
								tsSf.setErr();
							}
							
							// Iʒm
							Intent intent = new Intent(DelayReceiver.UPDATE);
							TrainService.this.sendBroadcast(intent);

							Debug.t(TrainService.this, "TrainService end");
						} catch (RemoteException e) {
							Debug.d(TrainService.this, null, e);
						} catch (Exception e) {
							Debug.d(TrainService.this, null, e);
						} finally {
							if (!status) {
								PrefectureDao.getInstance().delete();
							}
							TrainService.this.stopSelf();
						}
					}
				};
				thread.start();
				thread = null;

			} catch (Exception e) {
				Debug.t(TrainService.this, e.getMessage());
				Debug.d(TrainService.this, null, e);
				throw new RemoteException();
			}
			return 0;
		}

		public void setListener(ITrainServiceCallback callback)
				throws RemoteException {
			TrainService.this.callbackRef = new WeakReference<ITrainServiceCallback>(
					callback);
		}

		public void stop() throws RemoteException {
			TrainService.this.stopSelf();
		}
	};

	@Override
	public IBinder onBind(Intent intent) {
		return impl;
	}
}
