package com.td.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import android.content.Context;
import android.widget.Toast;

import com.td.db.Monitor;
import com.td.test.TestException;
import com.td.test.TestUtil;
import com.td.utility.DateUtil;
import com.td.utility.Debug;

public class SchedulerTest {
	private static final int LEN = 10;
	
	public static void repeat(Context context){
		Calendar cal = Calendar.getInstance();
		Scheduler sc = new Scheduler();
		long t = cal.getTimeInMillis();
		
		sc.makeSchedule();
		
		for (int i = 0; i < 5; i++){
			t = sc.calcSchedule(t, LEN);
			Date d = DateUtil.getDate(t);
			String ymd = DateUtil.formattedYmd(DateUtil.getYmd(d));
			String hm = DateUtil.formattedHm(DateUtil.getHm(d));
			String msg = ymd + " " + hm;
			Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
		}
	}
	
	public static void main() {
		SchedulerTest obj = new SchedulerTest();

		Debug.i(obj, "start");
		try {
			test_nextSchedule();
			test_isContainListTerm();
			test_makeScheduleListMonitor();
			test_addListTermMonitor();
			test_addListTermTerm();
			test_isContain();
			test_addTermTerm();
		} catch (TestException e) {
			Debug.i(obj, null, e);
		}
		Debug.i(obj, "end");
	}

	public static void test_nextSchedule() throws TestException{
		Scheduler sc = null;
		long now = -1;
		long next = -1;
		int n1 = -1;
		Calendar cal1 = null;
		Calendar cal2 = null;
		List<Term>[] list = null;
		List<Term> l = null;
		Term t = null;
		int y = -1;
		int m = -1;
		int d = -1;
		int h = -1;
		int mi = -1;
		int y2 = -1;
		int m2 = -1;
		int d2 = -1;
		int h2 = -1;
		int mi2 = -1;
		
		
		for (int i = 0; i < 5; i++){
			sc = new Scheduler();
			Debug.d(sc, "case " + i);
			
			sc.clearSchedule();
			list = sc.getList();
			
			switch (i){
			case 0:
				// ̎Ԃ݂
				y = 2011;
				m = 7;
				d = 3;
				h = 10;
				mi = 0;
				cal1 = DateUtil.getCalendar(y, m, d, h, mi);
				now = cal1.getTimeInMillis();
				
				n1 = DateUtil.getWeek(cal1);
				l = list[n1];
				t = new Term(DateUtil.getHm(10, 0), DateUtil.getHm(10, 20));
				l.add(t);
				break;
			case 1:
				// ̎Ԃ݂ȂATԂ܂Č̎Ԃ̐擪
				y = 2011;
				m = 7;
				d = 3;
				h = 10;
				mi = 0;
				cal1 = DateUtil.getCalendar(y, m, d, h, mi);
				now = cal1.getTimeInMillis();

				n1 = DateUtil.getWeek(cal1);
				l = list[n1];
				// TEST
				//t = new Term(DateUtil.getHm(10, 0), DateUtil.getHm(10, 5));
				t = new Term(DateUtil.getHm(9, 30), DateUtil.getHm(9, 40));
				l.add(t);
				break;
			case 2:
				// ̎Term
				y = 2011;
				m = 7;
				d = 4;
				h = 22;
				mi = 11;
				cal1 = DateUtil.getCalendar(y, m, d, h, mi);
				now = cal1.getTimeInMillis();
				
				n1 = DateUtil.getWeek(cal1);
				l = list[n1];
				t = new Term(DateUtil.getHm(22, 10), DateUtil.getHm(22, 20));
				l.add(t);
				t = new Term(DateUtil.getHm(23, 0), DateUtil.getHm(24, 0));
				l.add(t);
				break;
			case 3:
				// j܂ŁATermB̔N
				y = 2011;
				m = 12;
				d = 31;
				h = 23;
				mi = 30;
				cal1 = DateUtil.getCalendar(y, m, d, h, mi);
				now = cal1.getTimeInMillis();
				
				n1 = DateUtil.getWeek(cal1);
				n1 = (n1 + 1) % DateUtil.WEEK;
				l = list[n1];
				t = new Term(DateUtil.getHm(1, 23), DateUtil.getHm(23, 35));
				l.add(t);
				break;
			case 4:
				// ܂ŎTerm݂
				y = 2011;
				m = 1;
				d = 1;
				h = 23;
				mi = 59;
				cal1 = DateUtil.getCalendar(y, m, d, h, mi);
				now = cal1.getTimeInMillis();
				
				n1 = DateUtil.getWeek(cal1);
				n1 = (n1 + 1) % DateUtil.WEEK;
				l = list[n1];
				t = new Term(DateUtil.getHm(0, 0), DateUtil.getHm(23, 59));
				l.add(t);
				break;
			}
			
			next = sc.nextSchedule(now, LEN);
			if (next < 0){
				throw new TestException();
			}
			cal2 = Calendar.getInstance();
			cal2.setTimeInMillis(next);
			y2 = DateUtil.getYear(cal2);
			m2 = DateUtil.getMonth(cal2);
			d2 = DateUtil.getDay(cal2);
			h2 = DateUtil.getHour(cal2);
			mi2 = DateUtil.getMinute(cal2);
			
			switch (i){
			case 0:
				mi += LEN;
				break;
			case 1:
				d += DateUtil.WEEK;
				// TEST
				//mi = 0;
				h = 9;
				mi = 30;
				break;
			case 2:
				h = 23;
				mi = 0;
				break;
			case 3:
				y = 2012;
				m = 1;
				d = 1;
				h = 1;
				mi = 23;
				break;
			case 4:
				y = 2011;
				m = 1;
				d = 2;
				h = 0;
				mi = 9;
				break;
			}
			
			TestUtil.equal(y, y2);
			TestUtil.equal(m, m2);
			TestUtil.equal(d, d2);
			TestUtil.equal(h, h2);
			TestUtil.equal(mi, mi2);
		}
	}
	
	public static void test_isContainListTerm() throws TestException {
		Scheduler sc = null;
		List<Term> l = null;
		Term t = null;
		int hm = -1;

		for (int i = 0; i < 4; i++) {
			sc = new Scheduler();
			l = new ArrayList<Term>();

			switch (i){
			case 0:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(3, 4);
				l.add(t);
				t = new Term(5, 6);
				l.add(t);
	
				hm = 7;
				break;
			case 1:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(4, 5);
				l.add(t);
				
				hm = 3;
				break;
			case 2:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(4, 5);
				l.add(t);
				
				hm = 0;
				break;
			case 3:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(4, 5);
				l.add(t);
				
				hm = 4;
				break;
			}
			int n = sc.isContain(l, hm);

			switch (i){
			case 0:
				TestUtil.equal(n, -1);
				break;
			case 1:
				TestUtil.equal(n, 2);
				break;
			case 2:
				TestUtil.equal(n, 1);
				break;
			case 3:
				TestUtil.equal(n, 0);
				break;
			}
		}
	}

	public static void test_makeScheduleListMonitor() throws TestException {
		Scheduler sc = null;
		List<Monitor> list = null;
		Monitor m = null;
		int n1 = -1;
		int n2 = -1;

		for (int i = 0; i < 2; i++) {
			sc = new Scheduler();
			list = new ArrayList<Monitor>();

			switch (i) {
			case 0:
				n1 = 2;
				n2 = 6;

				m = new Monitor(1, 2);
				m.setWeek(n1, true);
				m.setWeek(n2, true);
				list.add(m);

				m = new Monitor(2, 3);
				m.setWeek(n1 + 1, true);
				list.add(m);
				break;
			case 1:
				n1 = 0;
				n2 = 1;

				m = new Monitor(0, 1);
				m.setWeek(n1, true);
				m.setWeek(n2, true);
				list.add(m);

				m = new Monitor(2, 3);
				m.setWeek(n1, true);
				m.setWeek(n2, true);
				list.add(m);

				m = new Monitor(1, 2);
				m.setWeek(n1, true);
				m.setWeek(n2 + 1, true);
				list.add(m);
				break;
			}
			sc.makeSchedule(list);

			List<Term>[] lts = sc.getList();
			List<Term> lt = null;

			switch (i) {
			case 0:
				lt = lts[n1];
				TestUtil.equal(lt.size(), 1);
				TestUtil.isTrue(lt.get(0).equals(new Term(1, 2)));
				lt = lts[n2];
				TestUtil.equal(lt.size(), 1);
				TestUtil.isTrue(lt.get(0).equals(new Term(1, 2)));
				lt = lts[n1 + 1];
				TestUtil.equal(lt.size(), 1);
				TestUtil.isTrue(lt.get(0).equals(new Term(2, 3)));
				break;
			case 1:
				lt = lts[n1];
				TestUtil.equal(lt.size(), 1);
				TestUtil.isTrue(lt.get(0).equals(new Term(0, 3)));

				lt = lts[n2];
				TestUtil.equal(lt.size(), 2);
				TestUtil.isTrue(lt.get(0).equals(new Term(0, 1)));
				TestUtil.isTrue(lt.get(1).equals(new Term(2, 3)));

				lt = lts[n2 + 1];
				TestUtil.equal(lt.size(), 1);
				TestUtil.isTrue(lt.get(0).equals(new Term(1, 2)));
				break;
			}
		}
	}

	public static void test_addListTermMonitor() throws TestException {
		int n = -1;
		Monitor m = null;

		Scheduler sc = new Scheduler();
		sc.clearSchedule();
		List<Term>[] ll = sc.getList();
		List<Term> l = null;

		for (int i = 0; i < 2; i++) {
			switch (i) {
			case 0:
				n = 3;
				ll[n].add(new Term(1, 2));
				m = new Monitor(2, 3);
				m.setWeek(n, true);
				m.setWeek(n + 2, true);
				break;
			case 1:
				n = 0;
				ll[n].add(new Term(1, 2));
				m = new Monitor(3, 4);
				m.setWeek(n, true);
				break;
			}

			sc.add(ll, m);

			switch (i) {
			case 0:
				l = ll[n];
				TestUtil.equal(l.size(), 1);
				TestUtil.isTrue(l.get(0).equals(new Term(1, 3)));
				l = ll[n + 2];
				TestUtil.equal(l.size(), 1);
				TestUtil.isTrue(l.get(0).equals(new Term(2, 3)));
				break;
			case 1:
				l = ll[n];
				TestUtil.equal(l.size(), 2);
				TestUtil.isTrue(l.get(0).equals(new Term(1, 2)));
				TestUtil.isTrue(l.get(1).equals(new Term(3, 4)));
				break;
			}
		}
	}

	public static void test_addListTermTerm() throws TestException {
		Term t = null;
		Term t1 = null;

		for (int i = 0; i < 3; i++) {
			List<Term> l = new ArrayList<Term>();
			switch (i) {
			case 0:
				t = new Term(1, 3);
				l.add(t);
				t1 = new Term(2, 4);
				break;
			case 1:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(5, 6);
				l.add(t);
				t1 = new Term(3, 4);
				break;
			case 2:
				t = new Term(1, 2);
				l.add(t);
				t = new Term(3, 4);
				l.add(t);
				t1 = new Term(2, 3);
				break;
			}

			Scheduler sc = new Scheduler();
			sc.add(l, t1);

			switch (i) {
			case 0:
				TestUtil.equal(l.size(), 1);
				TestUtil.isTrue(l.get(0).equals(new Term(1, 4)));
				break;
			case 1:
				TestUtil.equal(l.size(), 3);
				TestUtil.isTrue(l.get(0).equals(new Term(1, 2)));
				TestUtil.isTrue(l.get(1).equals(new Term(3, 4)));
				TestUtil.isTrue(l.get(2).equals(new Term(5, 6)));
				break;
			case 2:
				TestUtil.equal(l.size(), 1);
				TestUtil.isTrue(l.get(0).equals(new Term(1, 4)));
				break;
			}
		}
	}

	public static void test_isContain() throws TestException {
		Term t1;
		Term t2;
		boolean b;
		int from1 = -1;
		int to1 = -1;
		int from2 = -1;
		int to2 = -1;
		Scheduler sc;

		for (int i = 0; i < 3; i++) {
			switch (i) {
			case 0:
				from1 = 1;
				to1 = 3;
				from2 = 2;
				to2 = 4;
				break;
			case 1:
				from1 = 1;
				to1 = 4;
				from2 = 2;
				to2 = 3;
				break;
			case 2:
				from1 = 1;
				to1 = 2;
				from2 = 3;
				to2 = 4;
				break;
			}
			sc = new Scheduler();
			t1 = new Term(from1, to1);
			t2 = new Term(from2, to2);
			b = sc.isContain(t1, t2);
			switch (i) {
			case 0:
				TestUtil.isTrue(b);
				break;
			case 1:
				TestUtil.isTrue(b);
				break;
			case 2:
				TestUtil.isFalse(b);
				break;
			}
		}
	}

	public static void test_addTermTerm() throws TestException {
		Term t1;
		Term t2;
		Term t3;
		int from1 = -1;
		int to1 = -1;
		int from2 = -1;
		int to2 = -1;
		int from3;
		int to3;
		Scheduler sc;

		for (int i = 0; i < 2; i++) {
			switch (i) {
			case 0:
				from1 = 1;
				to1 = 3;
				from2 = 2;
				to2 = 4;
				break;
			case 1:
				from1 = 1;
				to1 = 4;
				from2 = 2;
				to2 = 3;
				break;
			}
			sc = new Scheduler();
			t1 = new Term(from1, to1);
			t2 = new Term(from2, to2);
			t3 = sc.add(t1, t2);
			from3 = t3.getFrom();
			to3 = t3.getTo();
			switch (i) {
			case 0:
				TestUtil.equal(from3, 1);
				TestUtil.equal(to3, 4);
				break;
			case 1:
				TestUtil.equal(from3, 1);
				TestUtil.equal(to3, 4);
				break;
			}
		}
	}
}
