package com.td.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import com.td.db.Keyword;
import com.td.db.KeywordDao;
import com.td.db.Monitor;
import com.td.db.MonitorDao;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.utility.DateUtil;
import com.td.utility.Debug;

public class Scheduler {
	private static Calendar cal = Calendar.getInstance();
	private List<Term>[] list = null;
	private List<Keyword> keywords = null;
	private List<Train> trains = null;
	private Comparator<Term> comp = new Comparator<Term>() {
		public int compare(Term t1, Term t2) {
			return t1.getFrom() - t2.getFrom();
		}
	};

	public Scheduler() {

	}

	public void init() {
		Debug.d(this, "start init");
		makeSchedule();
		makeTrains();
		makeKeywords();
		Debug.d(this, "end init");
	}

	public long calcSchedule(long now, int len) {
		Debug.d(this, "start");
		long t = nextSchedule(now, len);
		Debug.d(this, "end");
		return t;
	}

	public long nextSchedule(long now, int len) {
		long next = now + 60 * len * 1000;

		cal.setTimeInMillis(next);
		Date date = cal.getTime();
		int h = date.getHours();
		int m = date.getMinutes();
		int hm = DateUtil.getHm(h, m);
		int w = date.getDay();

		for (int i = 0; i < DateUtil.WEEK + 1; i++) {
			int n = (w + i) % DateUtil.WEEK;
			List<Term> l = list[n];
			int j = isContain(l, hm);
			if (i == 0 && j == 0) {
				// N(next)AXPW[ł
				return next;
			}
			if (j > 0) {
				Term t = l.get(j - 1);
				// (next)from(next̎)
				return DateUtil.getTime(date, i, t.getFrom()).getTimeInMillis();
			}
			if (i > 0) {
				// ̗j̏ꍇ
				if (l.size() > 0) {
					Term t = l.get(0);
					// (next)AíAfrom
					return DateUtil.getTime(date, i, t.getFrom())
							.getTimeInMillis();
				}
			}
		}
		return -1;
	}

	public int isContain(List<Term> l, int hm) {
		int from;
		int to;

		for (int i = 0; i < l.size(); i++) {
			Term t = l.get(i);
			from = t.getFrom();
			to = t.getTo();
			if (from <= hm && hm <= to) {
				return 0;
			}
			if (hm < from) {
				return i + 1;
			}
		}
		return -1;
	}

	public void makeSchedule() {
		if (list != null) {
			return;
		}
		Debug.d(this, "update schedule");

		MonitorDao dao = MonitorDao.getInstance();
		List<Monitor> mList = dao.search();
		makeSchedule(mList);
	}

	public void makeTrains() {
		if (trains != null) {
			return;
		}
		Debug.d(this, "update trains");

		TrainDao dao = TrainDao.getInstance();
		trains = dao.search(true);
	}

	public void makeKeywords() {
		if (keywords != null) {
			return;
		}
		Debug.d(this, "update keywords");

		KeywordDao dao = KeywordDao.getInstance();
		keywords = dao.search();
	}

	public List<Term>[] getList() {
		return list;
	}

	public List<Train> getTrains() {
		return trains;
	}

	public List<Keyword> getKeywords() {
		return keywords;
	}

	public void makeSchedule(List<Monitor> mList) {
		clearSchedule();

		for (Monitor monitor : mList) {
			add(list, monitor);
		}
	}

	public void clearSchedule() {
		list = new List[DateUtil.WEEK];
		for (int i = 0; i < list.length; i++) {
			list[i] = new ArrayList<Term>();
		}
	}

	public void add(List<Term>[] ll, Monitor monitor) {
		Term term = new Term(monitor.getFrom(), monitor.getTo());
		for (int i = 0; i < DateUtil.WEEK; i++) {
			if (monitor.getWeek(i)) {
				add(ll[i], term);
			}
		}
	}

	public void add(List<Term> l, Term term) {
		int i = 0;
		while (i < l.size()) {
			Term t = l.get(i);
			if (isContain(t, term)) {
				term = add(t, term);
				l.remove(i);
				continue;
			}
			i++;
		}
		l.add(term);
		Collections.sort(l, comp);
	}

	public boolean isContain(Term t1, Term t2) {
		int from1 = t1.getFrom();
		int to1 = t1.getTo();
		int from2 = t2.getFrom();
		int to2 = t2.getTo();

		if (from1 <= from2 && from2 <= to1) {
			return true;
		}
		if (from1 <= to2 && to2 <= to1) {
			return true;
		}
		if (from2 <= from1 && from1 <= to2) {
			return true;
		}
		if (from2 <= to1 && to1 <= to2) {
			return true;
		}
		return false;
	}

	public Term add(Term t1, Term t2) {
		int from1 = t1.getFrom();
		int to1 = t1.getTo();
		int from2 = t2.getFrom();
		int to2 = t2.getTo();

		int from = (from1 < from2) ? from1 : from2;
		int to = (to1 > to2) ? to1 : to2;
		return new Term(from, to);
	}
}
