package com.td.db;

public class Train {
	private long id;
	private String name;
	private String searchText;
	private boolean selected;
	
	public Train(long id, String name, String searchText, int selected){
		this.id = id;
		this.name = name;
		this.searchText = searchText;
		this.selected = (selected != 0)? true : false;
	}
	
	public Train(long id, String name){
		this.id = id;
		this.name = name;
		this.searchText = null;
		this.selected = false;
	}
	
	public Train(){
		this(-1, null, null, 0);
	}
	
	public long getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public String getSearchText() {
		return searchText;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSearchText(String searchText) {
		this.searchText = searchText;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public void setName(String name) {
		this.name = name;
		this.searchText = name;
	}

	public void setSname(String sname) {
		this.searchText = sname;
	}
}
