package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.td.utility.Debug;

public class RelationDao {
	private static RelationDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement deleteStmt = null;

	public static RelationDao getInstance() {
		if (instance == null) {
			instance = new RelationDao();
		}
		return instance;
	}

	private RelationDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE RELATION (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "PID INTEGER,"
				+ "TID INTEGER" + ");");
	}

	public void init(SQLiteDatabase db) {

	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO RELATION (" + "PID, TID"
				+ ") VALUES (" + "?, ?" + ");");
		deleteStmt = db.compileStatement("DELETE FROM RELATION");
	}

	public List<Relation> search() {
		return search(null, null, android.provider.BaseColumns._ID);
	}

	public List<Relation> search(long pid) {
		String selection = "PID = ?";
		String[] selectionArgs = new String[1];

		selectionArgs[0] = String.valueOf(pid);

		return search(selection, selectionArgs,
				android.provider.BaseColumns._ID);
	}

	private List<Relation> search(String selection, String[] selectionArgs,
			String orderBy) {
		List<Relation> list = new ArrayList<Relation>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();
		Cursor cursor = db.query("RELATION", new String[] {
				android.provider.BaseColumns._ID, "PID", "TID" }, selection,
				selectionArgs, null, null, orderBy);

		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Relation relation = new Relation(cursor.getInt(0),
						cursor.getInt(1), cursor.getInt(2));
				list.add(relation);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public long addNT(Relation relation) {
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindLong(i++, relation.getPid());
		stmt.bindLong(i++, relation.getTid());
		long id = stmt.executeInsert();
		return id;
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
