package com.td.db;

import com.td.utility.DateUtil;

public class Log {
	private long id;
	private int ymd;
	private int hm;
	private String message;
	
	public Log(long id, int ymd, int hm, String message){	
		this.id = id;
		this.ymd = ymd;
		this.hm = hm;
		this.message = message;
	}
	
	public Log(int ymd, int hm, String message){	
		this(-1, ymd, hm, message);
	}
	
	public long getId(){
		return id;
	}
	public int getYmd() {
		return ymd;
	}
	public int getHm() {
		return hm;
	}
	public String getMessage() {
		return message;
	}
	
	public String toString() {
		return DateUtil.formattedYmd(ymd) + " " + DateUtil.formattedHm(hm)
				+ " " + message;
	}
}
