package com.td;

import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;

import com.td.db.History;
import com.td.db.HistoryDao;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.service.TrainTwitterAdapter;
import com.td.utility.BaseActivity;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;

public class HistoryListActivity extends BaseActivity {
	private TextView textView;
	private ListView listView;
	private Spinner spinner;
	private Button button1;
	private Button button2;
	private List<Train> trainList;

	private EditPrefUtil pref = new EditPrefUtil(this);

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.history_list);

		try {
			textView = (TextView) findViewById(R.id.textView91);
			listView = (ListView) findViewById(R.id.listView91);
			spinner = (Spinner) findViewById(R.id.spinner91);
			button1 = (Button) findViewById(R.id.button91);
			button2 = (Button) findViewById(R.id.button92);

			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					HistoryConfActivity.init(HistoryListActivity.this);
					Intent intent = new Intent(HistoryListActivity.this,
							(Class<?>) HistoryConfActivity.class);
					startActivityForResult(intent, 0);
				}
			});

			button2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					HistoryListActivity.this.finish();
				}
			});

			spinner.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					updateList();
				}

				public void onNothingSelected(AdapterView<?> parent) {
					;
				}
			});

			trainList = TrainDao.getInstance().search(true);
			if (Debug.isDebug()) {
				Train t;
				t = new Train(TrainTwitterAdapter.START_ID, "Jn");
				trainList.add(t);
				t = new Train(TrainTwitterAdapter.ERROR_ID, "G[");
				trainList.add(t);
				t = new Train(TrainTwitterAdapter.DELAY_ID, "x");
				trainList.add(t);
			}
			ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
					android.R.layout.simple_spinner_item);
			for (Train train : trainList) {
				adapter.add(train.getName());
			}
			spinner.setAdapter(adapter);
			adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			if (trainList.size() > 0) {
				updateList();
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		switch (resultCode) {
		case RESULT_OK:
			// ݒ肪ύXꂽ̂ŁAlǂݒ
			pref.remove(HistoryActivity.PREF_HIS_DATA);
			break;
		case RESULT_CANCELED:
			break;
		}
	}

	private void updateList() {
		int ymd = pref.getInt(HistoryActivity.PREF_HIS_YMD);
		int h1 = pref.getInt(HistoryActivity.PREF_HIS_ST_HOUR);
		int mi1 = pref.getInt(HistoryActivity.PREF_HIS_ST_MINUTE);
		int h2 = pref.getInt(HistoryActivity.PREF_HIS_EN_HOUR);
		int mi2 = pref.getInt(HistoryActivity.PREF_HIS_EN_MINUTE);
		int from = DateUtil.getHm(h1, mi1);
		int to = DateUtil.getHm(h2, mi2);

		HistoryDao hisDao = HistoryDao.getInstance();

		int n = spinner.getSelectedItemPosition();
		Train train = trainList.get(n);
		long id = train.getId();

		List<History> list = hisDao.search(this, id, ymd, from, to);

		HistoryListViewArrayAdapter adapter = new HistoryListViewArrayAdapter(
				this, R.layout.history_list_item_1, list);
		listView.setAdapter(adapter);

		String text = DateUtil.formattedDate(ymd, from, to);
		textView.setText(text);

	}
}
