/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class ArcShape
implements Shape {
    private RectF mOval;
    private Path mPath;
    private Region mRegion;
    private float mStartAngle;
    private float mAngleExtent;
    private PointF mStartPoint;
    private PointF mEndPoint;
    private boolean mUseCenter;

    public ArcShape() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ArcShape(float x, float y) {
        this(x, y, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ArcShape(float x, float y, float width, float height) {
        this(x, y, width, height, 0.0f, 0.0f);
    }

    public ArcShape(float x, float y, float width, float height, float startAngle, float angleExtent) {
        this(x, y, width, height, startAngle, angleExtent, true);
    }

    public ArcShape(float x, float y, float width, float height, float startAngle, float angleExtent, boolean useCenter) {
        this.mOval = new RectF(x, y, x + width, y + height);
        this.mStartAngle = startAngle;
        this.mAngleExtent = angleExtent;
        this.mPath = new Path();
        this.mStartPoint = new PointF();
        this.mEndPoint = new PointF();
        this.mUseCenter = useCenter;
        this.mRegion = new Region();
        this.update();
    }

    public ArcShape(double x, double y, double width, double height, double startAngle, double angleExtent, boolean useCenter) {
        this.mOval = new RectF((float)x, (float)y, (float)(x + width), (float)(y + height));
        this.mStartAngle = (float)startAngle;
        this.mAngleExtent = (float)angleExtent;
        this.mPath = new Path();
        this.mStartPoint = new PointF();
        this.mEndPoint = new PointF();
        this.mUseCenter = useCenter;
        this.update();
    }

    public ArcShape(RectShape rect, float startAngle, float angleExtent, boolean useCenter) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), startAngle, angleExtent, useCenter);
    }

    public ArcShape(RectShape rect, double startAngle, double angleExtent, boolean useCenter) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), (float)startAngle, (float)angleExtent, useCenter);
    }

    public ArcShape(ArcShape arcShape) {
        this.mOval = arcShape.mOval;
        this.mStartAngle = arcShape.mStartAngle;
        this.mAngleExtent = arcShape.mAngleExtent;
        this.mStartPoint = new PointF(arcShape.mStartPoint.x, arcShape.mStartPoint.y);
        this.mEndPoint = new PointF(arcShape.mEndPoint.x, arcShape.mEndPoint.y);
        this.mPath = arcShape.mPath;
        this.mRegion = arcShape.mRegion;
        this.mUseCenter = arcShape.mUseCenter;
    }

    public Path getPath() {
        return this.mPath;
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawArc(this.mOval, this.mStartAngle, this.mAngleExtent, this.mUseCenter, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.mOval, this.mStartAngle, this.mAngleExtent, this.mUseCenter, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawArc(this.mOval, this.mStartAngle, this.mAngleExtent, this.mUseCenter, paint);
    }

    public void clip(Canvas canvas) {
        canvas.clipPath(this.mPath);
    }

    public boolean contains(RectShape rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(float x, float y) {
        return this.mRegion.contains((int)x, (int)y);
    }

    public boolean contains(float x, float y, float width, float height) {
        Region tmpRegion = new Region();
        Region targetRegion = new Region((int)x, (int)y, (int)(width + x), (int)(height + y));
        tmpRegion.op(this.mRegion, targetRegion, Region.Op.INTERSECT);
        return !targetRegion.op(tmpRegion, Region.Op.XOR);
    }

    public boolean contains(PointF point) {
        return this.mRegion.contains((int)point.x, (int)point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        return new RectShape(this.mRegion.getBounds());
    }

    public void getBounds(RectShape rect) {
        rect.setRect(this.mRegion.getBounds());
    }

    public boolean intersects(float x, float y, float width, float height) {
        float tmph;
        float tmpy;
        float tmpw;
        float tmpx;
        Region region = new Region(this.mRegion);
        if (x < width + x) {
            tmpx = x;
            tmpw = width;
        } else {
            tmpx = width + x;
            tmpw = Math.abs(width);
        }
        if (y < height + y) {
            tmpy = y;
            tmph = height;
        } else {
            tmpy = height + y;
            tmph = Math.abs(height);
        }
        return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        this.mOval.left += x;
        this.mOval.right += x;
        this.mOval.top += y;
        this.mOval.bottom += y;
        this.update();
    }

    public void setArc(RectShape arcRect, float startAngle, float antleExtent, boolean useCenter) {
        this.mOval = new RectF(arcRect.getRectF());
        this.mStartAngle = startAngle;
        this.mAngleExtent = antleExtent;
        this.mUseCenter = useCenter;
        this.update();
    }

    public void setArc(RectShape arcRect, double startAngle, double angleExtent, boolean useCenter) {
        this.mOval = new RectF(arcRect.getRectF());
        this.mStartAngle = (float)startAngle;
        this.mAngleExtent = (float)angleExtent;
        this.mUseCenter = useCenter;
        this.update();
    }

    public float getX() {
        return this.mOval.left;
    }

    public float getY() {
        return this.mOval.top;
    }

    public float getWidth() {
        return this.mOval.width();
    }

    public float getHeight() {
        return this.mOval.height();
    }

    public float getMinX() {
        return this.mOval.left;
    }

    public float getMaxX() {
        return this.mOval.right;
    }

    public float getMinY() {
        return this.mOval.top;
    }

    public float getMaxY() {
        return this.mOval.bottom;
    }

    public float getCenterX() {
        return this.mOval.centerX();
    }

    public float getCenterY() {
        return this.mOval.centerY();
    }

    public float getAngleStart() {
        return this.mStartAngle;
    }

    public void setAngleStart(float degree) {
        this.mStartAngle = degree;
        this.update();
    }

    public float getAngleExtent() {
        return this.mAngleExtent;
    }

    public void setAngleExtent(float degree) {
        this.mAngleExtent = degree;
        this.update();
    }

    public PointF getStartPoint() {
        return new PointF(this.mStartPoint.x, this.mStartPoint.y);
    }

    public PointF getEndPoint() {
        return new PointF(this.mEndPoint.x, this.mEndPoint.y);
    }

    public boolean isUseCenter() {
        return this.mUseCenter;
    }

    public void setUseCenter(boolean useCenter) {
        this.mUseCenter = useCenter;
    }

    private void update() {
        this.mPath.reset();
        this.mStartPoint.x = (float)(Math.sin(Math.toRadians((double)this.mStartAngle + 90.0)) * ((double)this.mOval.width() / 2.0)) + this.getCenterX();
        this.mStartPoint.y = (float)(-Math.cos(Math.toRadians((double)this.mStartAngle + 90.0)) * ((double)this.mOval.height() / 2.0)) + this.getCenterY();
        this.mEndPoint.x = (float)(Math.sin(Math.toRadians((double)(this.mStartAngle + this.mAngleExtent) + 90.0)) * ((double)this.mOval.width() / 2.0)) + this.getCenterX();
        this.mEndPoint.y = (float)(-Math.cos(Math.toRadians((double)(this.mStartAngle + this.mAngleExtent) + 90.0)) * ((double)this.mOval.height() / 2.0)) + this.getCenterY();
        this.mPath.arcTo(this.mOval, this.mStartAngle, this.mAngleExtent);
        if (this.mUseCenter) {
            this.mPath.lineTo(this.mOval.centerX(), this.mOval.centerY());
        }
        this.mPath.close();
        this.mRegion = new Region((int)this.mOval.left, (int)this.mOval.top, (int)this.mOval.right, (int)this.mOval.bottom);
        this.mRegion.setPath(this.mPath, this.mRegion);
    }

    public boolean equals(Object o) {
        if (o instanceof ArcShape) {
            ArcShape arcShape = (ArcShape)o;
            if (this.mOval.left == arcShape.mOval.left && this.mOval.right == arcShape.mOval.right && this.mOval.top == arcShape.mOval.top && this.mOval.bottom == arcShape.mOval.bottom && this.mStartAngle == arcShape.mStartAngle && this.mAngleExtent == arcShape.mAngleExtent && this.mUseCenter == arcShape.mUseCenter) {
                return true;
            }
        }
        return false;
    }

    public Shape clone() {
        return new ArcShape(this);
    }
}

